<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoices $parameters
     * @return \StructType\GetInvoicesResponse|bool
     */
    public function GetInvoices(\StructType\GetInvoices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicesRaw
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicesRaw $parameters
     * @return \StructType\GetInvoicesRawResponse|bool
     */
    public function GetInvoicesRaw(\StructType\GetInvoicesRaw $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInvoicesRaw($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReconciliationDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReconciliationDetail $parameters
     * @return \StructType\GetReconciliationDetailResponse|bool
     */
    public function GetReconciliationDetail(\StructType\GetReconciliationDetail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReconciliationDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomers $parameters
     * @return \StructType\GetCustomersResponse|bool
     */
    public function GetCustomers(\StructType\GetCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCustomersResponse|\StructType\GetInvoicesRawResponse|\StructType\GetInvoicesResponse|\StructType\GetReconciliationDetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
