<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerInquiry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerInquiry $parameters
     * @return \StructType\CustomerInquiryResponse|bool
     */
    public function CustomerInquiry(\StructType\CustomerInquiry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CustomerInquiry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerInquiryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
