<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Approve ServiceType
 * @subpackage Services
 */
class Approve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ApproveDraftInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApproveDraftInvoice $parameters
     * @return \StructType\ApproveDraftInvoiceResponse|bool
     */
    public function ApproveDraftInvoice(\StructType\ApproveDraftInvoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApproveDraftInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ApproveDraftInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
