<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'RequestBase' => '\\StructType\\RequestBase',
            'RequestHeader' => '\\StructType\\RequestHeader',
            'ResponseBase' => '\\StructType\\ResponseBase',
            'ResponseHeader' => '\\StructType\\ResponseHeader',
            'InvoiceInquiryRequest' => '\\StructType\\InvoiceInquiryRequest',
            'InvoiceInquiryResponse' => '\\StructType\\InvoiceInquiryResponse',
            'CancelInvoiceWithKEPRequest' => '\\StructType\\CancelInvoiceWithKEPRequest',
            'CancelInvoiceWithKEPResponse' => '\\StructType\\CancelInvoiceWithKEPResponse',
            'ArrayOfstring' => '\\ArrayType\\ArrayOfstring',
            'InvoiceBody' => '\\StructType\\InvoiceBody',
            'CustomerParty' => '\\StructType\\CustomerParty',
            'Contact' => '\\StructType\\Contact',
            'Party' => '\\StructType\\Party',
            'AgentParty' => '\\StructType\\AgentParty',
            'ArrayOfPartyIdentification' => '\\ArrayType\\ArrayOfPartyIdentification',
            'PartyIdentification' => '\\StructType\\PartyIdentification',
            'Person' => '\\StructType\\Person',
            'FinancialAccount' => '\\StructType\\FinancialAccount',
            'Branch' => '\\StructType\\Branch',
            'IdentityDocumentReference' => '\\StructType\\IdentityDocumentReference',
            'Attachment' => '\\StructType\\Attachment',
            'Period' => '\\StructType\\Period',
            'Address' => '\\StructType\\Address',
            'Country' => '\\StructType\\Country',
            'ArrayOfPartyLegalEntity' => '\\ArrayType\\ArrayOfPartyLegalEntity',
            'PartyLegalEntity' => '\\StructType\\PartyLegalEntity',
            'CorporateRegistrationScheme' => '\\StructType\\CorporateRegistrationScheme',
            'Amount' => '\\StructType\\Amount',
            'HeadParty' => '\\StructType\\HeadParty',
            'Location' => '\\StructType\\Location',
            'SupplierParty' => '\\StructType\\SupplierParty',
            'ArrayOfDocumentReference' => '\\ArrayType\\ArrayOfDocumentReference',
            'DocumentReference' => '\\StructType\\DocumentReference',
            'AllowanceCharge' => '\\StructType\\AllowanceCharge',
            'ArrayOfAllowanceCharge' => '\\ArrayType\\ArrayOfAllowanceCharge',
            'ArrayOfBillingReference' => '\\ArrayType\\ArrayOfBillingReference',
            'BillingReference' => '\\StructType\\BillingReference',
            'ArrayOfBillingReferenceLine' => '\\ArrayType\\ArrayOfBillingReferenceLine',
            'BillingReferenceLine' => '\\StructType\\BillingReferenceLine',
            'ArrayOfDelivery' => '\\ArrayType\\ArrayOfDelivery',
            'Delivery' => '\\StructType\\Delivery',
            'ArrayOfDeliveryTerms' => '\\ArrayType\\ArrayOfDeliveryTerms',
            'DeliveryTerms' => '\\StructType\\DeliveryTerms',
            'Despatch' => '\\StructType\\Despatch',
            'Shipment' => '\\StructType\\Shipment',
            'ArrayOfGoodsItem' => '\\ArrayType\\ArrayOfGoodsItem',
            'GoodsItem' => '\\StructType\\GoodsItem',
            'Measure' => '\\StructType\\Measure',
            'ArrayOfInvoiceLine' => '\\ArrayType\\ArrayOfInvoiceLine',
            'InvoiceLine' => '\\StructType\\InvoiceLine',
            'ArrayOfLineReference' => '\\ArrayType\\ArrayOfLineReference',
            'LineReference' => '\\StructType\\LineReference',
            'Item' => '\\StructType\\Item',
            'ArrayOfCommodityClassification' => '\\ArrayType\\ArrayOfCommodityClassification',
            'CommodityClassification' => '\\StructType\\CommodityClassification',
            'ItemClassificationCode' => '\\StructType\\ItemClassificationCode',
            'OriginCountry' => '\\StructType\\OriginCountry',
            'ArrayOfOrderLineReference' => '\\ArrayType\\ArrayOfOrderLineReference',
            'OrderLineReference' => '\\StructType\\OrderLineReference',
            'OrderReference' => '\\StructType\\OrderReference',
            'ArrayOfInvoiceSubLine' => '\\ArrayType\\ArrayOfInvoiceSubLine',
            'InvoiceSubLine' => '\\StructType\\InvoiceSubLine',
            'TaxTotal' => '\\StructType\\TaxTotal',
            'ArrayOfTaxSubtotal' => '\\ArrayType\\ArrayOfTaxSubtotal',
            'TaxSubtotal' => '\\StructType\\TaxSubtotal',
            'ArrayOfTaxTotal' => '\\ArrayType\\ArrayOfTaxTotal',
            'ArrayOfItem' => '\\ArrayType\\ArrayOfItem',
            'ArrayOfDimension' => '\\ArrayType\\ArrayOfDimension',
            'Dimension' => '\\StructType\\Dimension',
            'ArrayOfTemperature' => '\\ArrayType\\ArrayOfTemperature',
            'Temperature' => '\\StructType\\Temperature',
            'ArrayOfShipmentStage' => '\\ArrayType\\ArrayOfShipmentStage',
            'ShipmentStage' => '\\StructType\\ShipmentStage',
            'ArrayOfPerson' => '\\ArrayType\\ArrayOfPerson',
            'TransportMeans' => '\\StructType\\TransportMeans',
            'AirTransport' => '\\StructType\\AirTransport',
            'ArrayOfParty' => '\\ArrayType\\ArrayOfParty',
            'MaritimeTransport' => '\\StructType\\MaritimeTransport',
            'RailTransport' => '\\StructType\\RailTransport',
            'RoadTransport' => '\\StructType\\RoadTransport',
            'Stowage' => '\\StructType\\Stowage',
            'ArrayOfLocation' => '\\ArrayType\\ArrayOfLocation',
            'ArrayOfTransportHandlingUnit' => '\\ArrayType\\ArrayOfTransportHandlingUnit',
            'TransportHandlingUnit' => '\\StructType\\TransportHandlingUnit',
            'ArrayOfPackage' => '\\ArrayType\\ArrayOfPackage',
            'Package' => '\\StructType\\Package',
            'ArrayOfContainedPackage' => '\\ArrayType\\ArrayOfContainedPackage',
            'ContainedPackage' => '\\StructType\\ContainedPackage',
            'ArrayOfHazardousGoodsTransit' => '\\ArrayType\\ArrayOfHazardousGoodsTransit',
            'HazardousGoodsTransit' => '\\StructType\\HazardousGoodsTransit',
            'ArrayOfTransportEquipment' => '\\ArrayType\\ArrayOfTransportEquipment',
            'TransportEquipment' => '\\StructType\\TransportEquipment',
            'ArrayOfTransportMeans' => '\\ArrayType\\ArrayOfTransportMeans',
            'MonetaryTotal' => '\\StructType\\MonetaryTotal',
            'ExchangeRate' => '\\StructType\\ExchangeRate',
            'ArrayOfPaymentMeans' => '\\ArrayType\\ArrayOfPaymentMeans',
            'PaymentMeans' => '\\StructType\\PaymentMeans',
            'PaymentTerms' => '\\StructType\\PaymentTerms',
            'OutgoingInvoiceHeader' => '\\StructType\\OutgoingInvoiceHeader',
            'OnlineSaleInfo' => '\\StructType\\OnlineSaleInfo',
            'OnlineSaleShippingInfo' => '\\StructType\\OnlineSaleShippingInfo',
            'PaymentRecorderInfo' => '\\StructType\\PaymentRecorderInfo',
            'SmsConfigurationInfo' => '\\StructType\\SmsConfigurationInfo',
            'ArrayOfInvoiceResultItem' => '\\ArrayType\\ArrayOfInvoiceResultItem',
            'InvoiceResultItem' => '\\StructType\\InvoiceResultItem',
            'IncomingInvoiceHeader' => '\\StructType\\IncomingInvoiceHeader',
            'SendInvoicesRequest' => '\\StructType\\SendInvoicesRequest',
            'ArrayOfOutgoingInvoice' => '\\ArrayType\\ArrayOfOutgoingInvoice',
            'OutgoingInvoice' => '\\StructType\\OutgoingInvoice',
            'SendInvoicesResponse' => '\\StructType\\SendInvoicesResponse',
            'SendInvoicesRawRequest' => '\\StructType\\SendInvoicesRawRequest',
            'ArrayOfOutgoingInvoiceRaw' => '\\ArrayType\\ArrayOfOutgoingInvoiceRaw',
            'OutgoingInvoiceRaw' => '\\StructType\\OutgoingInvoiceRaw',
            'SendInvoicesRawResponse' => '\\StructType\\SendInvoicesRawResponse',
            'GetInvoicesRequest' => '\\StructType\\GetInvoicesRequest',
            'GetInvoicesResponse' => '\\StructType\\GetInvoicesResponse',
            'ArrayOfIncomingInvoice' => '\\ArrayType\\ArrayOfIncomingInvoice',
            'IncomingInvoice' => '\\StructType\\IncomingInvoice',
            'GetInvoicesRawRequest' => '\\StructType\\GetInvoicesRawRequest',
            'GetInvoicesRawResponse' => '\\StructType\\GetInvoicesRawResponse',
            'ArrayOfIncomingInvoiceRaw' => '\\ArrayType\\ArrayOfIncomingInvoiceRaw',
            'IncomingInvoiceRaw' => '\\StructType\\IncomingInvoiceRaw',
            'ReplylInvoicesRequest' => '\\StructType\\ReplylInvoicesRequest',
            'ArrayOfReplyInvoiceItem' => '\\ArrayType\\ArrayOfReplyInvoiceItem',
            'ReplyInvoiceItem' => '\\StructType\\ReplyInvoiceItem',
            'ReplylInvoicesResponse' => '\\StructType\\ReplylInvoicesResponse',
            'ArrayOfProcessResultItem' => '\\ArrayType\\ArrayOfProcessResultItem',
            'ProcessResultItem' => '\\StructType\\ProcessResultItem',
            'CustomerInquiryRequest' => '\\StructType\\CustomerInquiryRequest',
            'CustomerInquiryResponse' => '\\StructType\\CustomerInquiryResponse',
            'ArrayOfCustomer' => '\\ArrayType\\ArrayOfCustomer',
            'Customer' => '\\StructType\\Customer',
            'ArrayOfReceiverAlias' => '\\ArrayType\\ArrayOfReceiverAlias',
            'ReceiverAlias' => '\\StructType\\ReceiverAlias',
            'ReconciliationInquiryRequest' => '\\StructType\\ReconciliationInquiryRequest',
            'ReconciliationInquiryResponse' => '\\StructType\\ReconciliationInquiryResponse',
            'DoReconciliationRequest' => '\\StructType\\DoReconciliationRequest',
            'DoReconciliationResponse' => '\\StructType\\DoReconciliationResponse',
            'ArrayOfReconciliationDeliveryDetail' => '\\ArrayType\\ArrayOfReconciliationDeliveryDetail',
            'ReconciliationDeliveryDetail' => '\\StructType\\ReconciliationDeliveryDetail',
            'GetReconciliationDetailRequest' => '\\StructType\\GetReconciliationDetailRequest',
            'GetReconciliationDetailResponse' => '\\StructType\\GetReconciliationDetailResponse',
            'GetCustomersRequest' => '\\StructType\\GetCustomersRequest',
            'GetCustomersResponse' => '\\StructType\\GetCustomersResponse',
            'DownloadInvoiceRequest' => '\\StructType\\DownloadInvoiceRequest',
            'DownloadInvoiceResponse' => '\\StructType\\DownloadInvoiceResponse',
            'PreviewInvoiceRequest' => '\\StructType\\PreviewInvoiceRequest',
            'InvoiceToPreview' => '\\StructType\\InvoiceToPreview',
            'PreviewInvoiceResponse' => '\\StructType\\PreviewInvoiceResponse',
            'PreviewInvoiceRawRequest' => '\\StructType\\PreviewInvoiceRawRequest',
            'PreviewInvoiceRawResponse' => '\\StructType\\PreviewInvoiceRawResponse',
            'CreateNewContactRequest' => '\\StructType\\CreateNewContactRequest',
            'CreateNewContactResponse' => '\\StructType\\CreateNewContactResponse',
            'CancelInvoiceRequest' => '\\StructType\\CancelInvoiceRequest',
            'CancelInvoiceResponse' => '\\StructType\\CancelInvoiceResponse',
            'CustomPostBoxEnvelopeInquiryRequest' => '\\StructType\\CustomPostBoxEnvelopeInquiryRequest',
            'CustomPostBoxEnvelopeInquiryResponse' => '\\StructType\\CustomPostBoxEnvelopeInquiryResponse',
            'ArrayOfCustomPostBoxEnvelopeDTO' => '\\ArrayType\\ArrayOfCustomPostBoxEnvelopeDTO',
            'CustomPostBoxEnvelopeDTO' => '\\StructType\\CustomPostBoxEnvelopeDTO',
            'ApproveDraftInvoiceRequest' => '\\StructType\\ApproveDraftInvoiceRequest',
            'ApproveDraftInvoiceResponse' => '\\StructType\\ApproveDraftInvoiceResponse',
            'RepeatEArchiveSMSRequest' => '\\StructType\\RepeatEArchiveSMSRequest',
            'RepeatEArchiveSMSResponse' => '\\StructType\\RepeatEArchiveSMSResponse',
            'InvoiceInquiry' => '\\StructType\\InvoiceInquiry',
            'ReturnInvoiceWithKEP' => '\\StructType\\ReturnInvoiceWithKEP',
            'ReturnInvoiceWithKEPResponse' => '\\StructType\\ReturnInvoiceWithKEPResponse',
            'SendInvoices' => '\\StructType\\SendInvoices',
            'SendInvoicesRaw' => '\\StructType\\SendInvoicesRaw',
            'GetInvoices' => '\\StructType\\GetInvoices',
            'GetInvoicesRaw' => '\\StructType\\GetInvoicesRaw',
            'ReplyInvoices' => '\\StructType\\ReplyInvoices',
            'ReplyInvoicesResponse' => '\\StructType\\ReplyInvoicesResponse',
            'CustomerInquiry' => '\\StructType\\CustomerInquiry',
            'ReconciliationInquiry' => '\\StructType\\ReconciliationInquiry',
            'DoReconciliation' => '\\StructType\\DoReconciliation',
            'GetReconciliationDetail' => '\\StructType\\GetReconciliationDetail',
            'GetCustomers' => '\\StructType\\GetCustomers',
            'DownloadInvoice' => '\\StructType\\DownloadInvoice',
            'PreviewInvoice' => '\\StructType\\PreviewInvoice',
            'PreviewInvoiceRaw' => '\\StructType\\PreviewInvoiceRaw',
            'CreateNewContact' => '\\StructType\\CreateNewContact',
            'PingClientInterfaceService' => '\\StructType\\PingClientInterfaceService',
            'PingClientInterfaceServiceResponse' => '\\StructType\\PingClientInterfaceServiceResponse',
            'CancelInvoice' => '\\StructType\\CancelInvoice',
            'CustomPostBoxEnvelopeInquiry' => '\\StructType\\CustomPostBoxEnvelopeInquiry',
            'ApproveDraftInvoice' => '\\StructType\\ApproveDraftInvoice',
            'RepeatEArchiveSms' => '\\StructType\\RepeatEArchiveSms',
            'RepeatEArchiveSmsResponse' => '\\StructType\\RepeatEArchiveSmsResponse_1',
        );
    }
}
