<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTemperature ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTemperature
 * @subpackage Arrays
 */
class ArrayOfTemperature extends AbstractStructArrayBase
{
    /**
     * The Temperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Temperature[]
     */
    public $Temperature;
    /**
     * Constructor method for ArrayOfTemperature
     * @uses ArrayOfTemperature::setTemperature()
     * @param \StructType\Temperature[] $temperature
     */
    public function __construct(array $temperature = array())
    {
        $this
            ->setTemperature($temperature);
    }
    /**
     * Get Temperature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Temperature[]|null
     */
    public function getTemperature()
    {
        return isset($this->Temperature) ? $this->Temperature : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureForArrayConstraintsFromSetTemperature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTemperatureTemperatureItem) {
            // validation for constraint: itemType
            if (!$arrayOfTemperatureTemperatureItem instanceof \StructType\Temperature) {
                $invalidValues[] = is_object($arrayOfTemperatureTemperatureItem) ? get_class($arrayOfTemperatureTemperatureItem) : sprintf('%s(%s)', gettype($arrayOfTemperatureTemperatureItem), var_export($arrayOfTemperatureTemperatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Temperature property can only contain items of type \StructType\Temperature, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Temperature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Temperature[] $temperature
     * @return \ArrayType\ArrayOfTemperature
     */
    public function setTemperature(array $temperature = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureArrayErrorMessage = self::validateTemperatureForArrayConstraintsFromSetTemperature($temperature))) {
            throw new \InvalidArgumentException($temperatureArrayErrorMessage, __LINE__);
        }
        if (is_null($temperature) || (is_array($temperature) && empty($temperature))) {
            unset($this->Temperature);
        } else {
            $this->Temperature = $temperature;
        }
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \StructType\Temperature $item
     * @return \ArrayType\ArrayOfTemperature
     */
    public function addToTemperature(\StructType\Temperature $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Temperature) {
            throw new \InvalidArgumentException(sprintf('The Temperature property can only contain items of type \StructType\Temperature, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Temperature|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Temperature|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Temperature|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Temperature|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Temperature|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Temperature
     */
    public function getAttributeName()
    {
        return 'Temperature';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTemperature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
