<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPartyLegalEntity ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPartyLegalEntity
 * @subpackage Arrays
 */
class ArrayOfPartyLegalEntity extends AbstractStructArrayBase
{
    /**
     * The PartyLegalEntity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PartyLegalEntity[]
     */
    public $PartyLegalEntity;
    /**
     * Constructor method for ArrayOfPartyLegalEntity
     * @uses ArrayOfPartyLegalEntity::setPartyLegalEntity()
     * @param \StructType\PartyLegalEntity[] $partyLegalEntity
     */
    public function __construct(array $partyLegalEntity = array())
    {
        $this
            ->setPartyLegalEntity($partyLegalEntity);
    }
    /**
     * Get PartyLegalEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PartyLegalEntity[]|null
     */
    public function getPartyLegalEntity()
    {
        return isset($this->PartyLegalEntity) ? $this->PartyLegalEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyLegalEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyLegalEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPartyLegalEntityPartyLegalEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfPartyLegalEntityPartyLegalEntityItem instanceof \StructType\PartyLegalEntity) {
                $invalidValues[] = is_object($arrayOfPartyLegalEntityPartyLegalEntityItem) ? get_class($arrayOfPartyLegalEntityPartyLegalEntityItem) : sprintf('%s(%s)', gettype($arrayOfPartyLegalEntityPartyLegalEntityItem), var_export($arrayOfPartyLegalEntityPartyLegalEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyLegalEntity property can only contain items of type \StructType\PartyLegalEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyLegalEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PartyLegalEntity[] $partyLegalEntity
     * @return \ArrayType\ArrayOfPartyLegalEntity
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($partyLegalEntityArrayErrorMessage = self::validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity($partyLegalEntity))) {
            throw new \InvalidArgumentException($partyLegalEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($partyLegalEntity) || (is_array($partyLegalEntity) && empty($partyLegalEntity))) {
            unset($this->PartyLegalEntity);
        } else {
            $this->PartyLegalEntity = $partyLegalEntity;
        }
        return $this;
    }
    /**
     * Add item to PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyLegalEntity $item
     * @return \ArrayType\ArrayOfPartyLegalEntity
     */
    public function addToPartyLegalEntity(\StructType\PartyLegalEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartyLegalEntity) {
            throw new \InvalidArgumentException(sprintf('The PartyLegalEntity property can only contain items of type \StructType\PartyLegalEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyLegalEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PartyLegalEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PartyLegalEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PartyLegalEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PartyLegalEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PartyLegalEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PartyLegalEntity
     */
    public function getAttributeName()
    {
        return 'PartyLegalEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPartyLegalEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
