<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParty ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfParty
 * @subpackage Arrays
 */
class ArrayOfParty extends AbstractStructArrayBase
{
    /**
     * The Party
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party[]
     */
    public $Party;
    /**
     * Constructor method for ArrayOfParty
     * @uses ArrayOfParty::setParty()
     * @param \StructType\Party[] $party
     */
    public function __construct(array $party = array())
    {
        $this
            ->setParty($party);
    }
    /**
     * Get Party value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party[]|null
     */
    public function getParty()
    {
        return isset($this->Party) ? $this->Party : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyForArrayConstraintsFromSetParty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPartyPartyItem) {
            // validation for constraint: itemType
            if (!$arrayOfPartyPartyItem instanceof \StructType\Party) {
                $invalidValues[] = is_object($arrayOfPartyPartyItem) ? get_class($arrayOfPartyPartyItem) : sprintf('%s(%s)', gettype($arrayOfPartyPartyItem), var_export($arrayOfPartyPartyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Party property can only contain items of type \StructType\Party, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Party value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Party[] $party
     * @return \ArrayType\ArrayOfParty
     */
    public function setParty(array $party = array())
    {
        // validation for constraint: array
        if ('' !== ($partyArrayErrorMessage = self::validatePartyForArrayConstraintsFromSetParty($party))) {
            throw new \InvalidArgumentException($partyArrayErrorMessage, __LINE__);
        }
        if (is_null($party) || (is_array($party) && empty($party))) {
            unset($this->Party);
        } else {
            $this->Party = $party;
        }
        return $this;
    }
    /**
     * Add item to Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party $item
     * @return \ArrayType\ArrayOfParty
     */
    public function addToParty(\StructType\Party $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Party) {
            throw new \InvalidArgumentException(sprintf('The Party property can only contain items of type \StructType\Party, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Party[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Party|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Party|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Party|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Party|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Party|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Party
     */
    public function getAttributeName()
    {
        return 'Party';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfParty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
