<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLineReference
 * @subpackage Arrays
 */
class ArrayOfLineReference extends AbstractStructArrayBase
{
    /**
     * The LineReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LineReference[]
     */
    public $LineReference;
    /**
     * Constructor method for ArrayOfLineReference
     * @uses ArrayOfLineReference::setLineReference()
     * @param \StructType\LineReference[] $lineReference
     */
    public function __construct(array $lineReference = array())
    {
        $this
            ->setLineReference($lineReference);
    }
    /**
     * Get LineReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineReference[]|null
     */
    public function getLineReference()
    {
        return isset($this->LineReference) ? $this->LineReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineReferenceForArrayConstraintsFromSetLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLineReferenceLineReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineReferenceLineReferenceItem instanceof \StructType\LineReference) {
                $invalidValues[] = is_object($arrayOfLineReferenceLineReferenceItem) ? get_class($arrayOfLineReferenceLineReferenceItem) : sprintf('%s(%s)', gettype($arrayOfLineReferenceLineReferenceItem), var_export($arrayOfLineReferenceLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineReference property can only contain items of type \StructType\LineReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LineReference[] $lineReference
     * @return \ArrayType\ArrayOfLineReference
     */
    public function setLineReference(array $lineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($lineReferenceArrayErrorMessage = self::validateLineReferenceForArrayConstraintsFromSetLineReference($lineReference))) {
            throw new \InvalidArgumentException($lineReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($lineReference) || (is_array($lineReference) && empty($lineReference))) {
            unset($this->LineReference);
        } else {
            $this->LineReference = $lineReference;
        }
        return $this;
    }
    /**
     * Add item to LineReference value
     * @throws \InvalidArgumentException
     * @param \StructType\LineReference $item
     * @return \ArrayType\ArrayOfLineReference
     */
    public function addToLineReference(\StructType\LineReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineReference) {
            throw new \InvalidArgumentException(sprintf('The LineReference property can only contain items of type \StructType\LineReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LineReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LineReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LineReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LineReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LineReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineReference
     */
    public function getAttributeName()
    {
        return 'LineReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLineReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
