<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceResultItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfInvoiceResultItem
 * @subpackage Arrays
 */
class ArrayOfInvoiceResultItem extends AbstractStructArrayBase
{
    /**
     * The InvoiceResultItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceResultItem[]
     */
    public $InvoiceResultItem;
    /**
     * Constructor method for ArrayOfInvoiceResultItem
     * @uses ArrayOfInvoiceResultItem::setInvoiceResultItem()
     * @param \StructType\InvoiceResultItem[] $invoiceResultItem
     */
    public function __construct(array $invoiceResultItem = array())
    {
        $this
            ->setInvoiceResultItem($invoiceResultItem);
    }
    /**
     * Get InvoiceResultItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceResultItem[]|null
     */
    public function getInvoiceResultItem()
    {
        return isset($this->InvoiceResultItem) ? $this->InvoiceResultItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceResultItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceResultItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceResultItemForArrayConstraintsFromSetInvoiceResultItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceResultItemInvoiceResultItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceResultItemInvoiceResultItemItem instanceof \StructType\InvoiceResultItem) {
                $invalidValues[] = is_object($arrayOfInvoiceResultItemInvoiceResultItemItem) ? get_class($arrayOfInvoiceResultItemInvoiceResultItemItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceResultItemInvoiceResultItemItem), var_export($arrayOfInvoiceResultItemInvoiceResultItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceResultItem property can only contain items of type \StructType\InvoiceResultItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceResultItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceResultItem[] $invoiceResultItem
     * @return \ArrayType\ArrayOfInvoiceResultItem
     */
    public function setInvoiceResultItem(array $invoiceResultItem = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceResultItemArrayErrorMessage = self::validateInvoiceResultItemForArrayConstraintsFromSetInvoiceResultItem($invoiceResultItem))) {
            throw new \InvalidArgumentException($invoiceResultItemArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceResultItem) || (is_array($invoiceResultItem) && empty($invoiceResultItem))) {
            unset($this->InvoiceResultItem);
        } else {
            $this->InvoiceResultItem = $invoiceResultItem;
        }
        return $this;
    }
    /**
     * Add item to InvoiceResultItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceResultItem $item
     * @return \ArrayType\ArrayOfInvoiceResultItem
     */
    public function addToInvoiceResultItem(\StructType\InvoiceResultItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceResultItem) {
            throw new \InvalidArgumentException(sprintf('The InvoiceResultItem property can only contain items of type \StructType\InvoiceResultItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceResultItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceResultItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceResultItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceResultItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceResultItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceResultItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceResultItem
     */
    public function getAttributeName()
    {
        return 'InvoiceResultItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInvoiceResultItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
