<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIncomingInvoice ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfIncomingInvoice
 * @subpackage Arrays
 */
class ArrayOfIncomingInvoice extends AbstractStructArrayBase
{
    /**
     * The IncomingInvoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IncomingInvoice[]
     */
    public $IncomingInvoice;
    /**
     * Constructor method for ArrayOfIncomingInvoice
     * @uses ArrayOfIncomingInvoice::setIncomingInvoice()
     * @param \StructType\IncomingInvoice[] $incomingInvoice
     */
    public function __construct(array $incomingInvoice = array())
    {
        $this
            ->setIncomingInvoice($incomingInvoice);
    }
    /**
     * Get IncomingInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IncomingInvoice[]|null
     */
    public function getIncomingInvoice()
    {
        return isset($this->IncomingInvoice) ? $this->IncomingInvoice : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIncomingInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncomingInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncomingInvoiceForArrayConstraintsFromSetIncomingInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIncomingInvoiceIncomingInvoiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfIncomingInvoiceIncomingInvoiceItem instanceof \StructType\IncomingInvoice) {
                $invalidValues[] = is_object($arrayOfIncomingInvoiceIncomingInvoiceItem) ? get_class($arrayOfIncomingInvoiceIncomingInvoiceItem) : sprintf('%s(%s)', gettype($arrayOfIncomingInvoiceIncomingInvoiceItem), var_export($arrayOfIncomingInvoiceIncomingInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IncomingInvoice property can only contain items of type \StructType\IncomingInvoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IncomingInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingInvoice[] $incomingInvoice
     * @return \ArrayType\ArrayOfIncomingInvoice
     */
    public function setIncomingInvoice(array $incomingInvoice = array())
    {
        // validation for constraint: array
        if ('' !== ($incomingInvoiceArrayErrorMessage = self::validateIncomingInvoiceForArrayConstraintsFromSetIncomingInvoice($incomingInvoice))) {
            throw new \InvalidArgumentException($incomingInvoiceArrayErrorMessage, __LINE__);
        }
        if (is_null($incomingInvoice) || (is_array($incomingInvoice) && empty($incomingInvoice))) {
            unset($this->IncomingInvoice);
        } else {
            $this->IncomingInvoice = $incomingInvoice;
        }
        return $this;
    }
    /**
     * Add item to IncomingInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingInvoice $item
     * @return \ArrayType\ArrayOfIncomingInvoice
     */
    public function addToIncomingInvoice(\StructType\IncomingInvoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IncomingInvoice) {
            throw new \InvalidArgumentException(sprintf('The IncomingInvoice property can only contain items of type \StructType\IncomingInvoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IncomingInvoice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IncomingInvoice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IncomingInvoice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IncomingInvoice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IncomingInvoice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IncomingInvoice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IncomingInvoice
     */
    public function getAttributeName()
    {
        return 'IncomingInvoice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIncomingInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
