<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGoodsItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGoodsItem
 * @subpackage Arrays
 */
class ArrayOfGoodsItem extends AbstractStructArrayBase
{
    /**
     * The GoodsItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GoodsItem[]
     */
    public $GoodsItem;
    /**
     * Constructor method for ArrayOfGoodsItem
     * @uses ArrayOfGoodsItem::setGoodsItem()
     * @param \StructType\GoodsItem[] $goodsItem
     */
    public function __construct(array $goodsItem = array())
    {
        $this
            ->setGoodsItem($goodsItem);
    }
    /**
     * Get GoodsItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GoodsItem[]|null
     */
    public function getGoodsItem()
    {
        return isset($this->GoodsItem) ? $this->GoodsItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGoodsItemGoodsItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfGoodsItemGoodsItemItem instanceof \StructType\GoodsItem) {
                $invalidValues[] = is_object($arrayOfGoodsItemGoodsItemItem) ? get_class($arrayOfGoodsItemGoodsItemItem) : sprintf('%s(%s)', gettype($arrayOfGoodsItemGoodsItemItem), var_export($arrayOfGoodsItemGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \StructType\GoodsItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GoodsItem[] $goodsItem
     * @return \ArrayType\ArrayOfGoodsItem
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        if (is_null($goodsItem) || (is_array($goodsItem) && empty($goodsItem))) {
            unset($this->GoodsItem);
        } else {
            $this->GoodsItem = $goodsItem;
        }
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \StructType\GoodsItem $item
     * @return \ArrayType\ArrayOfGoodsItem
     */
    public function addToGoodsItem(\StructType\GoodsItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GoodsItem) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \StructType\GoodsItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GoodsItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GoodsItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GoodsItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GoodsItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GoodsItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GoodsItem
     */
    public function getAttributeName()
    {
        return 'GoodsItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGoodsItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
