<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDocumentReference
 * @subpackage Arrays
 */
class ArrayOfDocumentReference extends AbstractStructArrayBase
{
    /**
     * The DocumentReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference[]
     */
    public $DocumentReference;
    /**
     * Constructor method for ArrayOfDocumentReference
     * @uses ArrayOfDocumentReference::setDocumentReference()
     * @param \StructType\DocumentReference[] $documentReference
     */
    public function __construct(array $documentReference = array())
    {
        $this
            ->setDocumentReference($documentReference);
    }
    /**
     * Get DocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference[]|null
     */
    public function getDocumentReference()
    {
        return isset($this->DocumentReference) ? $this->DocumentReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentReferenceForArrayConstraintsFromSetDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentReferenceDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentReferenceDocumentReferenceItem instanceof \StructType\DocumentReference) {
                $invalidValues[] = is_object($arrayOfDocumentReferenceDocumentReferenceItem) ? get_class($arrayOfDocumentReferenceDocumentReferenceItem) : sprintf('%s(%s)', gettype($arrayOfDocumentReferenceDocumentReferenceItem), var_export($arrayOfDocumentReferenceDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentReference property can only contain items of type \StructType\DocumentReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentReference[] $documentReference
     * @return \ArrayType\ArrayOfDocumentReference
     */
    public function setDocumentReference(array $documentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($documentReferenceArrayErrorMessage = self::validateDocumentReferenceForArrayConstraintsFromSetDocumentReference($documentReference))) {
            throw new \InvalidArgumentException($documentReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($documentReference) || (is_array($documentReference) && empty($documentReference))) {
            unset($this->DocumentReference);
        } else {
            $this->DocumentReference = $documentReference;
        }
        return $this;
    }
    /**
     * Add item to DocumentReference value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentReference $item
     * @return \ArrayType\ArrayOfDocumentReference
     */
    public function addToDocumentReference(\StructType\DocumentReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentReference) {
            throw new \InvalidArgumentException(sprintf('The DocumentReference property can only contain items of type \StructType\DocumentReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentReference
     */
    public function getAttributeName()
    {
        return 'DocumentReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDocumentReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
