<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDimension ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDimension
 * @subpackage Arrays
 */
class ArrayOfDimension extends AbstractStructArrayBase
{
    /**
     * The Dimension
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dimension[]
     */
    public $Dimension;
    /**
     * Constructor method for ArrayOfDimension
     * @uses ArrayOfDimension::setDimension()
     * @param \StructType\Dimension[] $dimension
     */
    public function __construct(array $dimension = array())
    {
        $this
            ->setDimension($dimension);
    }
    /**
     * Get Dimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dimension[]|null
     */
    public function getDimension()
    {
        return isset($this->Dimension) ? $this->Dimension : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDimensionForArrayConstraintsFromSetDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDimensionDimensionItem) {
            // validation for constraint: itemType
            if (!$arrayOfDimensionDimensionItem instanceof \StructType\Dimension) {
                $invalidValues[] = is_object($arrayOfDimensionDimensionItem) ? get_class($arrayOfDimensionDimensionItem) : sprintf('%s(%s)', gettype($arrayOfDimensionDimensionItem), var_export($arrayOfDimensionDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dimension property can only contain items of type \StructType\Dimension, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Dimension[] $dimension
     * @return \ArrayType\ArrayOfDimension
     */
    public function setDimension(array $dimension = array())
    {
        // validation for constraint: array
        if ('' !== ($dimensionArrayErrorMessage = self::validateDimensionForArrayConstraintsFromSetDimension($dimension))) {
            throw new \InvalidArgumentException($dimensionArrayErrorMessage, __LINE__);
        }
        if (is_null($dimension) || (is_array($dimension) && empty($dimension))) {
            unset($this->Dimension);
        } else {
            $this->Dimension = $dimension;
        }
        return $this;
    }
    /**
     * Add item to Dimension value
     * @throws \InvalidArgumentException
     * @param \StructType\Dimension $item
     * @return \ArrayType\ArrayOfDimension
     */
    public function addToDimension(\StructType\Dimension $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dimension) {
            throw new \InvalidArgumentException(sprintf('The Dimension property can only contain items of type \StructType\Dimension, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dimension[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Dimension|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Dimension|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Dimension|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Dimension|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Dimension|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Dimension
     */
    public function getAttributeName()
    {
        return 'Dimension';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDimension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
