<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fop StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Fop
 * @subpackage Structs
 */
class Fop extends ApiObject
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The BankTransferInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentBankTransferInfo
     */
    public $BankTransferInfo;
    /**
     * The CheckInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentCheckInfo
     */
    public $CheckInfo;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The MCOInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentMCOInfo
     */
    public $MCOInfo;
    /**
     * The MiscInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentMiscInfo
     */
    public $MiscInfo;
    /**
     * The RedirectInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentRedirectInfo
     */
    public $RedirectInfo;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * The RefClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefClient;
    /**
     * The SecureCardInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentSecureCardInfo
     */
    public $SecureCardInfo;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * The UnsecureCardInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\FormOfPaymentUnsecureCardInfo
     */
    public $UnsecureCardInfo;
    /**
     * Constructor method for Fop
     * @uses Fop::setAmount()
     * @uses Fop::setBankTransferInfo()
     * @uses Fop::setCheckInfo()
     * @uses Fop::setCode()
     * @uses Fop::setMCOInfo()
     * @uses Fop::setMiscInfo()
     * @uses Fop::setRedirectInfo()
     * @uses Fop::setRef()
     * @uses Fop::setRefClient()
     * @uses Fop::setSecureCardInfo()
     * @uses Fop::setText()
     * @uses Fop::setUnsecureCardInfo()
     * @param float $amount
     * @param \App|C\StructType\FormOfPaymentBankTransferInfo $bankTransferInfo
     * @param \App|C\StructType\FormOfPaymentCheckInfo $checkInfo
     * @param string $code
     * @param \App|C\StructType\FormOfPaymentMCOInfo $mCOInfo
     * @param \App|C\StructType\FormOfPaymentMiscInfo $miscInfo
     * @param \App|C\StructType\FormOfPaymentRedirectInfo $redirectInfo
     * @param string $ref
     * @param string $refClient
     * @param \App|C\StructType\FormOfPaymentSecureCardInfo $secureCardInfo
     * @param string $text
     * @param \App|C\StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo
     */
    public function __construct($amount = null, \App|C\StructType\FormOfPaymentBankTransferInfo $bankTransferInfo = null, \App|C\StructType\FormOfPaymentCheckInfo $checkInfo = null, $code = null, \App|C\StructType\FormOfPaymentMCOInfo $mCOInfo = null, \App|C\StructType\FormOfPaymentMiscInfo $miscInfo = null, \App|C\StructType\FormOfPaymentRedirectInfo $redirectInfo = null, $ref = null, $refClient = null, \App|C\StructType\FormOfPaymentSecureCardInfo $secureCardInfo = null, $text = null, \App|C\StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo = null)
    {
        $this
            ->setAmount($amount)
            ->setBankTransferInfo($bankTransferInfo)
            ->setCheckInfo($checkInfo)
            ->setCode($code)
            ->setMCOInfo($mCOInfo)
            ->setMiscInfo($miscInfo)
            ->setRedirectInfo($redirectInfo)
            ->setRef($ref)
            ->setRefClient($refClient)
            ->setSecureCardInfo($secureCardInfo)
            ->setText($text)
            ->setUnsecureCardInfo($unsecureCardInfo);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \App|C\StructType\Fop
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BankTransferInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentBankTransferInfo|null
     */
    public function getBankTransferInfo()
    {
        return isset($this->BankTransferInfo) ? $this->BankTransferInfo : null;
    }
    /**
     * Set BankTransferInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentBankTransferInfo $bankTransferInfo
     * @return \App|C\StructType\Fop
     */
    public function setBankTransferInfo(\App|C\StructType\FormOfPaymentBankTransferInfo $bankTransferInfo = null)
    {
        if (is_null($bankTransferInfo) || (is_array($bankTransferInfo) && empty($bankTransferInfo))) {
            unset($this->BankTransferInfo);
        } else {
            $this->BankTransferInfo = $bankTransferInfo;
        }
        return $this;
    }
    /**
     * Get CheckInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentCheckInfo|null
     */
    public function getCheckInfo()
    {
        return isset($this->CheckInfo) ? $this->CheckInfo : null;
    }
    /**
     * Set CheckInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentCheckInfo $checkInfo
     * @return \App|C\StructType\Fop
     */
    public function setCheckInfo(\App|C\StructType\FormOfPaymentCheckInfo $checkInfo = null)
    {
        if (is_null($checkInfo) || (is_array($checkInfo) && empty($checkInfo))) {
            unset($this->CheckInfo);
        } else {
            $this->CheckInfo = $checkInfo;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\Fop
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get MCOInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentMCOInfo|null
     */
    public function getMCOInfo()
    {
        return isset($this->MCOInfo) ? $this->MCOInfo : null;
    }
    /**
     * Set MCOInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentMCOInfo $mCOInfo
     * @return \App|C\StructType\Fop
     */
    public function setMCOInfo(\App|C\StructType\FormOfPaymentMCOInfo $mCOInfo = null)
    {
        if (is_null($mCOInfo) || (is_array($mCOInfo) && empty($mCOInfo))) {
            unset($this->MCOInfo);
        } else {
            $this->MCOInfo = $mCOInfo;
        }
        return $this;
    }
    /**
     * Get MiscInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentMiscInfo|null
     */
    public function getMiscInfo()
    {
        return isset($this->MiscInfo) ? $this->MiscInfo : null;
    }
    /**
     * Set MiscInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentMiscInfo $miscInfo
     * @return \App|C\StructType\Fop
     */
    public function setMiscInfo(\App|C\StructType\FormOfPaymentMiscInfo $miscInfo = null)
    {
        if (is_null($miscInfo) || (is_array($miscInfo) && empty($miscInfo))) {
            unset($this->MiscInfo);
        } else {
            $this->MiscInfo = $miscInfo;
        }
        return $this;
    }
    /**
     * Get RedirectInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentRedirectInfo|null
     */
    public function getRedirectInfo()
    {
        return isset($this->RedirectInfo) ? $this->RedirectInfo : null;
    }
    /**
     * Set RedirectInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentRedirectInfo $redirectInfo
     * @return \App|C\StructType\Fop
     */
    public function setRedirectInfo(\App|C\StructType\FormOfPaymentRedirectInfo $redirectInfo = null)
    {
        if (is_null($redirectInfo) || (is_array($redirectInfo) && empty($redirectInfo))) {
            unset($this->RedirectInfo);
        } else {
            $this->RedirectInfo = $redirectInfo;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \App|C\StructType\Fop
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
    /**
     * Get RefClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefClient()
    {
        return isset($this->RefClient) ? $this->RefClient : null;
    }
    /**
     * Set RefClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refClient
     * @return \App|C\StructType\Fop
     */
    public function setRefClient($refClient = null)
    {
        // validation for constraint: string
        if (!is_null($refClient) && !is_string($refClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refClient, true), gettype($refClient)), __LINE__);
        }
        if (is_null($refClient) || (is_array($refClient) && empty($refClient))) {
            unset($this->RefClient);
        } else {
            $this->RefClient = $refClient;
        }
        return $this;
    }
    /**
     * Get SecureCardInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentSecureCardInfo|null
     */
    public function getSecureCardInfo()
    {
        return isset($this->SecureCardInfo) ? $this->SecureCardInfo : null;
    }
    /**
     * Set SecureCardInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentSecureCardInfo $secureCardInfo
     * @return \App|C\StructType\Fop
     */
    public function setSecureCardInfo(\App|C\StructType\FormOfPaymentSecureCardInfo $secureCardInfo = null)
    {
        if (is_null($secureCardInfo) || (is_array($secureCardInfo) && empty($secureCardInfo))) {
            unset($this->SecureCardInfo);
        } else {
            $this->SecureCardInfo = $secureCardInfo;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \App|C\StructType\Fop
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get UnsecureCardInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\FormOfPaymentUnsecureCardInfo|null
     */
    public function getUnsecureCardInfo()
    {
        return isset($this->UnsecureCardInfo) ? $this->UnsecureCardInfo : null;
    }
    /**
     * Set UnsecureCardInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo
     * @return \App|C\StructType\Fop
     */
    public function setUnsecureCardInfo(\App|C\StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo = null)
    {
        if (is_null($unsecureCardInfo) || (is_array($unsecureCardInfo) && empty($unsecureCardInfo))) {
            unset($this->UnsecureCardInfo);
        } else {
            $this->UnsecureCardInfo = $unsecureCardInfo;
        }
        return $this;
    }
}
