<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatRow
 * @subpackage Structs
 */
class SeatRow extends ApiObject
{
    /**
     * The Columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfSeatColumn
     */
    public $Columns;
    /**
     * The Curtains
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Curtains;
    /**
     * The LeftSideTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeftSideTypeCode;
    /**
     * The RightSideTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RightSideTypeCode;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowNumber;
    /**
     * Constructor method for SeatRow
     * @uses SeatRow::setColumns()
     * @uses SeatRow::setCurtains()
     * @uses SeatRow::setLeftSideTypeCode()
     * @uses SeatRow::setRightSideTypeCode()
     * @uses SeatRow::setRowNumber()
     * @param \App|C\ArrayType\ArrayOfSeatColumn $columns
     * @param bool $curtains
     * @param string $leftSideTypeCode
     * @param string $rightSideTypeCode
     * @param int $rowNumber
     */
    public function __construct(\App|C\ArrayType\ArrayOfSeatColumn $columns = null, $curtains = null, $leftSideTypeCode = null, $rightSideTypeCode = null, $rowNumber = null)
    {
        $this
            ->setColumns($columns)
            ->setCurtains($curtains)
            ->setLeftSideTypeCode($leftSideTypeCode)
            ->setRightSideTypeCode($rightSideTypeCode)
            ->setRowNumber($rowNumber);
    }
    /**
     * Get Columns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfSeatColumn|null
     */
    public function getColumns()
    {
        return isset($this->Columns) ? $this->Columns : null;
    }
    /**
     * Set Columns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfSeatColumn $columns
     * @return \App|C\StructType\SeatRow
     */
    public function setColumns(\App|C\ArrayType\ArrayOfSeatColumn $columns = null)
    {
        if (is_null($columns) || (is_array($columns) && empty($columns))) {
            unset($this->Columns);
        } else {
            $this->Columns = $columns;
        }
        return $this;
    }
    /**
     * Get Curtains value
     * @return bool|null
     */
    public function getCurtains()
    {
        return $this->Curtains;
    }
    /**
     * Set Curtains value
     * @param bool $curtains
     * @return \App|C\StructType\SeatRow
     */
    public function setCurtains($curtains = null)
    {
        // validation for constraint: boolean
        if (!is_null($curtains) && !is_bool($curtains)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($curtains, true), gettype($curtains)), __LINE__);
        }
        $this->Curtains = $curtains;
        return $this;
    }
    /**
     * Get LeftSideTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftSideTypeCode()
    {
        return isset($this->LeftSideTypeCode) ? $this->LeftSideTypeCode : null;
    }
    /**
     * Set LeftSideTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftSideTypeCode
     * @return \App|C\StructType\SeatRow
     */
    public function setLeftSideTypeCode($leftSideTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($leftSideTypeCode) && !is_string($leftSideTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftSideTypeCode, true), gettype($leftSideTypeCode)), __LINE__);
        }
        if (is_null($leftSideTypeCode) || (is_array($leftSideTypeCode) && empty($leftSideTypeCode))) {
            unset($this->LeftSideTypeCode);
        } else {
            $this->LeftSideTypeCode = $leftSideTypeCode;
        }
        return $this;
    }
    /**
     * Get RightSideTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRightSideTypeCode()
    {
        return isset($this->RightSideTypeCode) ? $this->RightSideTypeCode : null;
    }
    /**
     * Set RightSideTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rightSideTypeCode
     * @return \App|C\StructType\SeatRow
     */
    public function setRightSideTypeCode($rightSideTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($rightSideTypeCode) && !is_string($rightSideTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightSideTypeCode, true), gettype($rightSideTypeCode)), __LINE__);
        }
        if (is_null($rightSideTypeCode) || (is_array($rightSideTypeCode) && empty($rightSideTypeCode))) {
            unset($this->RightSideTypeCode);
        } else {
            $this->RightSideTypeCode = $rightSideTypeCode;
        }
        return $this;
    }
    /**
     * Get RowNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowNumber()
    {
        return isset($this->RowNumber) ? $this->RowNumber : null;
    }
    /**
     * Set RowNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowNumber
     * @return \App|C\StructType\SeatRow
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        if (is_null($rowNumber) || (is_array($rowNumber) && empty($rowNumber))) {
            unset($this->RowNumber);
        } else {
            $this->RowNumber = $rowNumber;
        }
        return $this;
    }
}
