<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seat StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Seat
 * @subpackage Structs
 */
class Seat extends ApiObject
{
    /**
     * The AssociatedAncillaryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedAncillaryCode;
    /**
     * The IsAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailable;
    /**
     * The Letter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Letter;
    /**
     * The PassengerTypeCodeRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $PassengerTypeCodeRestrictions;
    /**
     * The RefPassenger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefPassenger;
    /**
     * The SeatTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeCode;
    /**
     * The SpecialServiceCodeRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $SpecialServiceCodeRestrictions;
    /**
     * Constructor method for Seat
     * @uses Seat::setAssociatedAncillaryCode()
     * @uses Seat::setIsAvailable()
     * @uses Seat::setLetter()
     * @uses Seat::setPassengerTypeCodeRestrictions()
     * @uses Seat::setRefPassenger()
     * @uses Seat::setSeatTypeCode()
     * @uses Seat::setSpecialServiceCodeRestrictions()
     * @param string $associatedAncillaryCode
     * @param bool $isAvailable
     * @param string $letter
     * @param \App|C\ArrayType\ArrayOfstring $passengerTypeCodeRestrictions
     * @param string $refPassenger
     * @param string $seatTypeCode
     * @param \App|C\ArrayType\ArrayOfstring $specialServiceCodeRestrictions
     */
    public function __construct($associatedAncillaryCode = null, $isAvailable = null, $letter = null, \App|C\ArrayType\ArrayOfstring $passengerTypeCodeRestrictions = null, $refPassenger = null, $seatTypeCode = null, \App|C\ArrayType\ArrayOfstring $specialServiceCodeRestrictions = null)
    {
        $this
            ->setAssociatedAncillaryCode($associatedAncillaryCode)
            ->setIsAvailable($isAvailable)
            ->setLetter($letter)
            ->setPassengerTypeCodeRestrictions($passengerTypeCodeRestrictions)
            ->setRefPassenger($refPassenger)
            ->setSeatTypeCode($seatTypeCode)
            ->setSpecialServiceCodeRestrictions($specialServiceCodeRestrictions);
    }
    /**
     * Get AssociatedAncillaryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedAncillaryCode()
    {
        return isset($this->AssociatedAncillaryCode) ? $this->AssociatedAncillaryCode : null;
    }
    /**
     * Set AssociatedAncillaryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedAncillaryCode
     * @return \App|C\StructType\Seat
     */
    public function setAssociatedAncillaryCode($associatedAncillaryCode = null)
    {
        // validation for constraint: string
        if (!is_null($associatedAncillaryCode) && !is_string($associatedAncillaryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedAncillaryCode, true), gettype($associatedAncillaryCode)), __LINE__);
        }
        if (is_null($associatedAncillaryCode) || (is_array($associatedAncillaryCode) && empty($associatedAncillaryCode))) {
            unset($this->AssociatedAncillaryCode);
        } else {
            $this->AssociatedAncillaryCode = $associatedAncillaryCode;
        }
        return $this;
    }
    /**
     * Get IsAvailable value
     * @return bool|null
     */
    public function getIsAvailable()
    {
        return $this->IsAvailable;
    }
    /**
     * Set IsAvailable value
     * @param bool $isAvailable
     * @return \App|C\StructType\Seat
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailable) && !is_bool($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailable, true), gettype($isAvailable)), __LINE__);
        }
        $this->IsAvailable = $isAvailable;
        return $this;
    }
    /**
     * Get Letter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLetter()
    {
        return isset($this->Letter) ? $this->Letter : null;
    }
    /**
     * Set Letter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $letter
     * @return \App|C\StructType\Seat
     */
    public function setLetter($letter = null)
    {
        // validation for constraint: string
        if (!is_null($letter) && !is_string($letter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letter, true), gettype($letter)), __LINE__);
        }
        if (is_null($letter) || (is_array($letter) && empty($letter))) {
            unset($this->Letter);
        } else {
            $this->Letter = $letter;
        }
        return $this;
    }
    /**
     * Get PassengerTypeCodeRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getPassengerTypeCodeRestrictions()
    {
        return isset($this->PassengerTypeCodeRestrictions) ? $this->PassengerTypeCodeRestrictions : null;
    }
    /**
     * Set PassengerTypeCodeRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $passengerTypeCodeRestrictions
     * @return \App|C\StructType\Seat
     */
    public function setPassengerTypeCodeRestrictions(\App|C\ArrayType\ArrayOfstring $passengerTypeCodeRestrictions = null)
    {
        if (is_null($passengerTypeCodeRestrictions) || (is_array($passengerTypeCodeRestrictions) && empty($passengerTypeCodeRestrictions))) {
            unset($this->PassengerTypeCodeRestrictions);
        } else {
            $this->PassengerTypeCodeRestrictions = $passengerTypeCodeRestrictions;
        }
        return $this;
    }
    /**
     * Get RefPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefPassenger()
    {
        return isset($this->RefPassenger) ? $this->RefPassenger : null;
    }
    /**
     * Set RefPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refPassenger
     * @return \App|C\StructType\Seat
     */
    public function setRefPassenger($refPassenger = null)
    {
        // validation for constraint: string
        if (!is_null($refPassenger) && !is_string($refPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refPassenger, true), gettype($refPassenger)), __LINE__);
        }
        if (is_null($refPassenger) || (is_array($refPassenger) && empty($refPassenger))) {
            unset($this->RefPassenger);
        } else {
            $this->RefPassenger = $refPassenger;
        }
        return $this;
    }
    /**
     * Get SeatTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeCode()
    {
        return isset($this->SeatTypeCode) ? $this->SeatTypeCode : null;
    }
    /**
     * Set SeatTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeCode
     * @return \App|C\StructType\Seat
     */
    public function setSeatTypeCode($seatTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeCode) && !is_string($seatTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeCode, true), gettype($seatTypeCode)), __LINE__);
        }
        if (is_null($seatTypeCode) || (is_array($seatTypeCode) && empty($seatTypeCode))) {
            unset($this->SeatTypeCode);
        } else {
            $this->SeatTypeCode = $seatTypeCode;
        }
        return $this;
    }
    /**
     * Get SpecialServiceCodeRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getSpecialServiceCodeRestrictions()
    {
        return isset($this->SpecialServiceCodeRestrictions) ? $this->SpecialServiceCodeRestrictions : null;
    }
    /**
     * Set SpecialServiceCodeRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $specialServiceCodeRestrictions
     * @return \App|C\StructType\Seat
     */
    public function setSpecialServiceCodeRestrictions(\App|C\ArrayType\ArrayOfstring $specialServiceCodeRestrictions = null)
    {
        if (is_null($specialServiceCodeRestrictions) || (is_array($specialServiceCodeRestrictions) && empty($specialServiceCodeRestrictions))) {
            unset($this->SpecialServiceCodeRestrictions);
        } else {
            $this->SpecialServiceCodeRestrictions = $specialServiceCodeRestrictions;
        }
        return $this;
    }
}
