<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerNameRecordInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerNameRecordInformation
 * @subpackage Structs
 */
class PassengerNameRecordInformation extends ApiObject
{
    /**
     * The CreatedDateGMT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDateGMT;
    /**
     * The MissingTravelerRecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MissingTravelerRecordLocator;
    /**
     * The ModifiedDateGMT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifiedDateGMT;
    /**
     * The PnrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrCode;
    /**
     * The PnrStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PnrStatusCode;
    /**
     * The RefCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefCustomer;
    /**
     * The TimeLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeLimit;
    /**
     * Constructor method for PassengerNameRecordInformation
     * @uses PassengerNameRecordInformation::setCreatedDateGMT()
     * @uses PassengerNameRecordInformation::setMissingTravelerRecordLocator()
     * @uses PassengerNameRecordInformation::setModifiedDateGMT()
     * @uses PassengerNameRecordInformation::setPnrCode()
     * @uses PassengerNameRecordInformation::setPnrStatusCode()
     * @uses PassengerNameRecordInformation::setRefCustomer()
     * @uses PassengerNameRecordInformation::setTimeLimit()
     * @param string $createdDateGMT
     * @param bool $missingTravelerRecordLocator
     * @param string $modifiedDateGMT
     * @param string $pnrCode
     * @param string $pnrStatusCode
     * @param string $refCustomer
     * @param string $timeLimit
     */
    public function __construct($createdDateGMT = null, $missingTravelerRecordLocator = null, $modifiedDateGMT = null, $pnrCode = null, $pnrStatusCode = null, $refCustomer = null, $timeLimit = null)
    {
        $this
            ->setCreatedDateGMT($createdDateGMT)
            ->setMissingTravelerRecordLocator($missingTravelerRecordLocator)
            ->setModifiedDateGMT($modifiedDateGMT)
            ->setPnrCode($pnrCode)
            ->setPnrStatusCode($pnrStatusCode)
            ->setRefCustomer($refCustomer)
            ->setTimeLimit($timeLimit);
    }
    /**
     * Get CreatedDateGMT value
     * @return string|null
     */
    public function getCreatedDateGMT()
    {
        return $this->CreatedDateGMT;
    }
    /**
     * Set CreatedDateGMT value
     * @param string $createdDateGMT
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setCreatedDateGMT($createdDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateGMT) && !is_string($createdDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDateGMT, true), gettype($createdDateGMT)), __LINE__);
        }
        $this->CreatedDateGMT = $createdDateGMT;
        return $this;
    }
    /**
     * Get MissingTravelerRecordLocator value
     * @return bool|null
     */
    public function getMissingTravelerRecordLocator()
    {
        return $this->MissingTravelerRecordLocator;
    }
    /**
     * Set MissingTravelerRecordLocator value
     * @param bool $missingTravelerRecordLocator
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setMissingTravelerRecordLocator($missingTravelerRecordLocator = null)
    {
        // validation for constraint: boolean
        if (!is_null($missingTravelerRecordLocator) && !is_bool($missingTravelerRecordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($missingTravelerRecordLocator, true), gettype($missingTravelerRecordLocator)), __LINE__);
        }
        $this->MissingTravelerRecordLocator = $missingTravelerRecordLocator;
        return $this;
    }
    /**
     * Get ModifiedDateGMT value
     * @return string|null
     */
    public function getModifiedDateGMT()
    {
        return $this->ModifiedDateGMT;
    }
    /**
     * Set ModifiedDateGMT value
     * @param string $modifiedDateGMT
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setModifiedDateGMT($modifiedDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDateGMT) && !is_string($modifiedDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDateGMT, true), gettype($modifiedDateGMT)), __LINE__);
        }
        $this->ModifiedDateGMT = $modifiedDateGMT;
        return $this;
    }
    /**
     * Get PnrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrCode()
    {
        return isset($this->PnrCode) ? $this->PnrCode : null;
    }
    /**
     * Set PnrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrCode
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setPnrCode($pnrCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrCode) && !is_string($pnrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrCode, true), gettype($pnrCode)), __LINE__);
        }
        if (is_null($pnrCode) || (is_array($pnrCode) && empty($pnrCode))) {
            unset($this->PnrCode);
        } else {
            $this->PnrCode = $pnrCode;
        }
        return $this;
    }
    /**
     * Get PnrStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPnrStatusCode()
    {
        return isset($this->PnrStatusCode) ? $this->PnrStatusCode : null;
    }
    /**
     * Set PnrStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pnrStatusCode
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setPnrStatusCode($pnrStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($pnrStatusCode) && !is_string($pnrStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnrStatusCode, true), gettype($pnrStatusCode)), __LINE__);
        }
        if (is_null($pnrStatusCode) || (is_array($pnrStatusCode) && empty($pnrStatusCode))) {
            unset($this->PnrStatusCode);
        } else {
            $this->PnrStatusCode = $pnrStatusCode;
        }
        return $this;
    }
    /**
     * Get RefCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefCustomer()
    {
        return isset($this->RefCustomer) ? $this->RefCustomer : null;
    }
    /**
     * Set RefCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refCustomer
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setRefCustomer($refCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($refCustomer) && !is_string($refCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCustomer, true), gettype($refCustomer)), __LINE__);
        }
        if (is_null($refCustomer) || (is_array($refCustomer) && empty($refCustomer))) {
            unset($this->RefCustomer);
        } else {
            $this->RefCustomer = $refCustomer;
        }
        return $this;
    }
    /**
     * Get TimeLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeLimit()
    {
        return isset($this->TimeLimit) ? $this->TimeLimit : null;
    }
    /**
     * Set TimeLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeLimit
     * @return \App|C\StructType\PassengerNameRecordInformation
     */
    public function setTimeLimit($timeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($timeLimit) && !is_string($timeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeLimit, true), gettype($timeLimit)), __LINE__);
        }
        if (is_null($timeLimit) || (is_array($timeLimit) && empty($timeLimit))) {
            unset($this->TimeLimit);
        } else {
            $this->TimeLimit = $timeLimit;
        }
        return $this;
    }
}
