<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundRequestSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundRequestSettings
 * @subpackage Structs
 */
class RefundRequestSettings extends ApiObject
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The RefundRequestActionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundRequestActionCode;
    /**
     * Constructor method for RefundRequestSettings
     * @uses RefundRequestSettings::setMessage()
     * @uses RefundRequestSettings::setRefundRequestActionCode()
     * @param string $message
     * @param string $refundRequestActionCode
     */
    public function __construct($message = null, $refundRequestActionCode = null)
    {
        $this
            ->setMessage($message)
            ->setRefundRequestActionCode($refundRequestActionCode);
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \App|C\StructType\RefundRequestSettings
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get RefundRequestActionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundRequestActionCode()
    {
        return isset($this->RefundRequestActionCode) ? $this->RefundRequestActionCode : null;
    }
    /**
     * Set RefundRequestActionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundRequestActionCode
     * @return \App|C\StructType\RefundRequestSettings
     */
    public function setRefundRequestActionCode($refundRequestActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($refundRequestActionCode) && !is_string($refundRequestActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundRequestActionCode, true), gettype($refundRequestActionCode)), __LINE__);
        }
        if (is_null($refundRequestActionCode) || (is_array($refundRequestActionCode) && empty($refundRequestActionCode))) {
            unset($this->RefundRequestActionCode);
        } else {
            $this->RefundRequestActionCode = $refundRequestActionCode;
        }
        return $this;
    }
}
