<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerMCOReference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerMCOReference
 * @subpackage Structs
 */
class CustomerMCOReference extends ApiObject
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Login;
    /**
     * The RefCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefCustomer;
    /**
     * Constructor method for CustomerMCOReference
     * @uses CustomerMCOReference::setLogin()
     * @uses CustomerMCOReference::setRefCustomer()
     * @param string $login
     * @param string $refCustomer
     */
    public function __construct($login = null, $refCustomer = null)
    {
        $this
            ->setLogin($login)
            ->setRefCustomer($refCustomer);
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \App|C\StructType\CustomerMCOReference
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Get RefCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefCustomer()
    {
        return isset($this->RefCustomer) ? $this->RefCustomer : null;
    }
    /**
     * Set RefCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refCustomer
     * @return \App|C\StructType\CustomerMCOReference
     */
    public function setRefCustomer($refCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($refCustomer) && !is_string($refCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCustomer, true), gettype($refCustomer)), __LINE__);
        }
        if (is_null($refCustomer) || (is_array($refCustomer) && empty($refCustomer))) {
            unset($this->RefCustomer);
        } else {
            $this->RefCustomer = $refCustomer;
        }
        return $this;
    }
}
