<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageResponse StructType
 * @subpackage Structs
 */
class MessageResponse extends AbstractStructBase
{
    /**
     * The ReceivedDateGMT
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ReceivedDateGMT;
    /**
     * The ProcessingTimeMs
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $ProcessingTimeMs;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App|C\StructType\MessageReponseWarning[]
     */
    public $Warnings;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * Constructor method for MessageResponse
     * @uses MessageResponse::setReceivedDateGMT()
     * @uses MessageResponse::setProcessingTimeMs()
     * @uses MessageResponse::setWarnings()
     * @uses MessageResponse::setEchoToken()
     * @param string $receivedDateGMT
     * @param float $processingTimeMs
     * @param \App|C\StructType\MessageReponseWarning[] $warnings
     * @param string $echoToken
     */
    public function __construct($receivedDateGMT = null, $processingTimeMs = null, array $warnings = array(), $echoToken = null)
    {
        $this
            ->setReceivedDateGMT($receivedDateGMT)
            ->setProcessingTimeMs($processingTimeMs)
            ->setWarnings($warnings)
            ->setEchoToken($echoToken);
    }
    /**
     * Get ReceivedDateGMT value
     * @return string
     */
    public function getReceivedDateGMT()
    {
        return $this->ReceivedDateGMT;
    }
    /**
     * Set ReceivedDateGMT value
     * @param string $receivedDateGMT
     * @return \App|C\StructType\MessageResponse
     */
    public function setReceivedDateGMT($receivedDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($receivedDateGMT) && !is_string($receivedDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedDateGMT, true), gettype($receivedDateGMT)), __LINE__);
        }
        $this->ReceivedDateGMT = $receivedDateGMT;
        return $this;
    }
    /**
     * Get ProcessingTimeMs value
     * @return float
     */
    public function getProcessingTimeMs()
    {
        return $this->ProcessingTimeMs;
    }
    /**
     * Set ProcessingTimeMs value
     * @param float $processingTimeMs
     * @return \App|C\StructType\MessageResponse
     */
    public function setProcessingTimeMs($processingTimeMs = null)
    {
        // validation for constraint: float
        if (!is_null($processingTimeMs) && !(is_float($processingTimeMs) || is_numeric($processingTimeMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($processingTimeMs, true), gettype($processingTimeMs)), __LINE__);
        }
        $this->ProcessingTimeMs = $processingTimeMs;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \App|C\StructType\MessageReponseWarning[]|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * This method is responsible for validating the values passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningsForArrayConstraintsFromSetWarnings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messageResponseWarningsItem) {
            // validation for constraint: itemType
            if (!$messageResponseWarningsItem instanceof \App|C\StructType\MessageReponseWarning) {
                $invalidValues[] = is_object($messageResponseWarningsItem) ? get_class($messageResponseWarningsItem) : sprintf('%s(%s)', gettype($messageResponseWarningsItem), var_export($messageResponseWarningsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warnings property can only contain items of type \App|C\StructType\MessageReponseWarning, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warnings value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\MessageReponseWarning[] $warnings
     * @return \App|C\StructType\MessageResponse
     */
    public function setWarnings(array $warnings = array())
    {
        // validation for constraint: array
        if ('' !== ($warningsArrayErrorMessage = self::validateWarningsForArrayConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsArrayErrorMessage, __LINE__);
        }
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Add item to Warnings value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\MessageReponseWarning $item
     * @return \App|C\StructType\MessageResponse
     */
    public function addToWarnings(\App|C\StructType\MessageReponseWarning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\MessageReponseWarning) {
            throw new \InvalidArgumentException(sprintf('The Warnings property can only contain items of type \App|C\StructType\MessageReponseWarning, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warnings[] = $item;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \App|C\StructType\MessageResponse
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
}
