<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirOriginDestination StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AirOriginDestination
 * @subpackage Structs
 */
class AirOriginDestination extends ApiObject
{
    /**
     * The AirCoupons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfAirCoupon
     */
    public $AirCoupons;
    /**
     * The OriginDestinationOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginDestinationOrder;
    /**
     * The RefFareRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefFareRule;
    /**
     * Constructor method for AirOriginDestination
     * @uses AirOriginDestination::setAirCoupons()
     * @uses AirOriginDestination::setOriginDestinationOrder()
     * @uses AirOriginDestination::setRefFareRule()
     * @param \App|C\ArrayType\ArrayOfAirCoupon $airCoupons
     * @param int $originDestinationOrder
     * @param string $refFareRule
     */
    public function __construct(\App|C\ArrayType\ArrayOfAirCoupon $airCoupons = null, $originDestinationOrder = null, $refFareRule = null)
    {
        $this
            ->setAirCoupons($airCoupons)
            ->setOriginDestinationOrder($originDestinationOrder)
            ->setRefFareRule($refFareRule);
    }
    /**
     * Get AirCoupons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfAirCoupon|null
     */
    public function getAirCoupons()
    {
        return isset($this->AirCoupons) ? $this->AirCoupons : null;
    }
    /**
     * Set AirCoupons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfAirCoupon $airCoupons
     * @return \App|C\StructType\AirOriginDestination
     */
    public function setAirCoupons(\App|C\ArrayType\ArrayOfAirCoupon $airCoupons = null)
    {
        if (is_null($airCoupons) || (is_array($airCoupons) && empty($airCoupons))) {
            unset($this->AirCoupons);
        } else {
            $this->AirCoupons = $airCoupons;
        }
        return $this;
    }
    /**
     * Get OriginDestinationOrder value
     * @return int|null
     */
    public function getOriginDestinationOrder()
    {
        return $this->OriginDestinationOrder;
    }
    /**
     * Set OriginDestinationOrder value
     * @param int $originDestinationOrder
     * @return \App|C\StructType\AirOriginDestination
     */
    public function setOriginDestinationOrder($originDestinationOrder = null)
    {
        // validation for constraint: int
        if (!is_null($originDestinationOrder) && !(is_int($originDestinationOrder) || ctype_digit($originDestinationOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originDestinationOrder, true), gettype($originDestinationOrder)), __LINE__);
        }
        $this->OriginDestinationOrder = $originDestinationOrder;
        return $this;
    }
    /**
     * Get RefFareRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefFareRule()
    {
        return isset($this->RefFareRule) ? $this->RefFareRule : null;
    }
    /**
     * Set RefFareRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refFareRule
     * @return \App|C\StructType\AirOriginDestination
     */
    public function setRefFareRule($refFareRule = null)
    {
        // validation for constraint: string
        if (!is_null($refFareRule) && !is_string($refFareRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refFareRule, true), gettype($refFareRule)), __LINE__);
        }
        if (is_null($refFareRule) || (is_array($refFareRule) && empty($refFareRule))) {
            unset($this->RefFareRule);
        } else {
            $this->RefFareRule = $refFareRule;
        }
        return $this;
    }
}
