<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\CreateBooking $parameters
     * @return \App|C\StructType\CreateBookingResponse|bool
     */
    public function CreateBooking(\App|C\StructType\CreateBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\CreateTicket $parameters
     * @return \App|C\StructType\CreateTicketResponse|bool
     */
    public function CreateTicket(\App|C\StructType\CreateTicket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\CreateBookingResponse|\App|C\StructType\CreateTicketResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
