<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyerLevel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FrequentFlyerLevel
 * @subpackage Structs
 */
class FrequentFlyerLevel extends ApiObject
{
    /**
     * The AccessCoupon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessCoupon;
    /**
     * The AccessMiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessMiles;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * Constructor method for FrequentFlyerLevel
     * @uses FrequentFlyerLevel::setAccessCoupon()
     * @uses FrequentFlyerLevel::setAccessMiles()
     * @uses FrequentFlyerLevel::setName()
     * @uses FrequentFlyerLevel::setRef()
     * @param int $accessCoupon
     * @param int $accessMiles
     * @param string $name
     * @param string $ref
     */
    public function __construct($accessCoupon = null, $accessMiles = null, $name = null, $ref = null)
    {
        $this
            ->setAccessCoupon($accessCoupon)
            ->setAccessMiles($accessMiles)
            ->setName($name)
            ->setRef($ref);
    }
    /**
     * Get AccessCoupon value
     * @return int|null
     */
    public function getAccessCoupon()
    {
        return $this->AccessCoupon;
    }
    /**
     * Set AccessCoupon value
     * @param int $accessCoupon
     * @return \App|C\StructType\FrequentFlyerLevel
     */
    public function setAccessCoupon($accessCoupon = null)
    {
        // validation for constraint: int
        if (!is_null($accessCoupon) && !(is_int($accessCoupon) || ctype_digit($accessCoupon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessCoupon, true), gettype($accessCoupon)), __LINE__);
        }
        $this->AccessCoupon = $accessCoupon;
        return $this;
    }
    /**
     * Get AccessMiles value
     * @return int|null
     */
    public function getAccessMiles()
    {
        return $this->AccessMiles;
    }
    /**
     * Set AccessMiles value
     * @param int $accessMiles
     * @return \App|C\StructType\FrequentFlyerLevel
     */
    public function setAccessMiles($accessMiles = null)
    {
        // validation for constraint: int
        if (!is_null($accessMiles) && !(is_int($accessMiles) || ctype_digit($accessMiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessMiles, true), gettype($accessMiles)), __LINE__);
        }
        $this->AccessMiles = $accessMiles;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \App|C\StructType\FrequentFlyerLevel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \App|C\StructType\FrequentFlyerLevel
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
}
