<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormOfPaymentConfig StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormOfPaymentConfig
 * @subpackage Structs
 */
class FormOfPaymentConfig extends ApiObject
{
    /**
     * The AllowedCurrencyCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfstring
     */
    public $AllowedCurrencyCodes;
    /**
     * The FopTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\Fop
     */
    public $FopTemplate;
    /**
     * The FormOfPaymentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormOfPaymentCode;
    /**
     * The FormOfPaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FormOfPaymentId;
    /**
     * The OnlinePaymentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\OnlinePaymentInfo
     */
    public $OnlinePaymentInfo;
    /**
     * Constructor method for FormOfPaymentConfig
     * @uses FormOfPaymentConfig::setAllowedCurrencyCodes()
     * @uses FormOfPaymentConfig::setFopTemplate()
     * @uses FormOfPaymentConfig::setFormOfPaymentCode()
     * @uses FormOfPaymentConfig::setFormOfPaymentId()
     * @uses FormOfPaymentConfig::setOnlinePaymentInfo()
     * @param \App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes
     * @param \App|C\StructType\Fop $fopTemplate
     * @param string $formOfPaymentCode
     * @param int $formOfPaymentId
     * @param \App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo
     */
    public function __construct(\App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes = null, \App|C\StructType\Fop $fopTemplate = null, $formOfPaymentCode = null, $formOfPaymentId = null, \App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo = null)
    {
        $this
            ->setAllowedCurrencyCodes($allowedCurrencyCodes)
            ->setFopTemplate($fopTemplate)
            ->setFormOfPaymentCode($formOfPaymentCode)
            ->setFormOfPaymentId($formOfPaymentId)
            ->setOnlinePaymentInfo($onlinePaymentInfo);
    }
    /**
     * Get AllowedCurrencyCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfstring|null
     */
    public function getAllowedCurrencyCodes()
    {
        return isset($this->AllowedCurrencyCodes) ? $this->AllowedCurrencyCodes : null;
    }
    /**
     * Set AllowedCurrencyCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setAllowedCurrencyCodes(\App|C\ArrayType\ArrayOfstring $allowedCurrencyCodes = null)
    {
        if (is_null($allowedCurrencyCodes) || (is_array($allowedCurrencyCodes) && empty($allowedCurrencyCodes))) {
            unset($this->AllowedCurrencyCodes);
        } else {
            $this->AllowedCurrencyCodes = $allowedCurrencyCodes;
        }
        return $this;
    }
    /**
     * Get FopTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\Fop|null
     */
    public function getFopTemplate()
    {
        return isset($this->FopTemplate) ? $this->FopTemplate : null;
    }
    /**
     * Set FopTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\Fop $fopTemplate
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setFopTemplate(\App|C\StructType\Fop $fopTemplate = null)
    {
        if (is_null($fopTemplate) || (is_array($fopTemplate) && empty($fopTemplate))) {
            unset($this->FopTemplate);
        } else {
            $this->FopTemplate = $fopTemplate;
        }
        return $this;
    }
    /**
     * Get FormOfPaymentCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormOfPaymentCode()
    {
        return isset($this->FormOfPaymentCode) ? $this->FormOfPaymentCode : null;
    }
    /**
     * Set FormOfPaymentCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formOfPaymentCode
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setFormOfPaymentCode($formOfPaymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($formOfPaymentCode) && !is_string($formOfPaymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formOfPaymentCode, true), gettype($formOfPaymentCode)), __LINE__);
        }
        if (is_null($formOfPaymentCode) || (is_array($formOfPaymentCode) && empty($formOfPaymentCode))) {
            unset($this->FormOfPaymentCode);
        } else {
            $this->FormOfPaymentCode = $formOfPaymentCode;
        }
        return $this;
    }
    /**
     * Get FormOfPaymentId value
     * @return int|null
     */
    public function getFormOfPaymentId()
    {
        return $this->FormOfPaymentId;
    }
    /**
     * Set FormOfPaymentId value
     * @param int $formOfPaymentId
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setFormOfPaymentId($formOfPaymentId = null)
    {
        // validation for constraint: int
        if (!is_null($formOfPaymentId) && !(is_int($formOfPaymentId) || ctype_digit($formOfPaymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formOfPaymentId, true), gettype($formOfPaymentId)), __LINE__);
        }
        $this->FormOfPaymentId = $formOfPaymentId;
        return $this;
    }
    /**
     * Get OnlinePaymentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\OnlinePaymentInfo|null
     */
    public function getOnlinePaymentInfo()
    {
        return isset($this->OnlinePaymentInfo) ? $this->OnlinePaymentInfo : null;
    }
    /**
     * Set OnlinePaymentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo
     * @return \App|C\StructType\FormOfPaymentConfig
     */
    public function setOnlinePaymentInfo(\App|C\StructType\OnlinePaymentInfo $onlinePaymentInfo = null)
    {
        if (is_null($onlinePaymentInfo) || (is_array($onlinePaymentInfo) && empty($onlinePaymentInfo))) {
            unset($this->OnlinePaymentInfo);
        } else {
            $this->OnlinePaymentInfo = $onlinePaymentInfo;
        }
        return $this;
    }
}
