<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelPendingExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\CancelPendingExchange $parameters
     * @return \App|C\StructType\CancelPendingExchangeResponse|bool
     */
    public function CancelPendingExchange(\App|C\StructType\CancelPendingExchange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelPendingExchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\Cancel $parameters
     * @return \App|C\StructType\CancelResponse|bool
     */
    public function Cancel(\App|C\StructType\Cancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\CancelPendingExchangeResponse|\App|C\StructType\CancelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
