<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checkin ServiceType
 * @subpackage Services
 */
class Checkin extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Checkin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\Checkin $parameters
     * @return \App|C\StructType\CheckinResponse|bool
     */
    public function Checkin(\App|C\StructType\Checkin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Checkin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\CheckinResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
