<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketTax StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketTax
 * @subpackage Structs
 */
class TicketTax extends ApiObject
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The SaleCurrencyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SaleCurrencyAmount;
    /**
     * Constructor method for TicketTax
     * @uses TicketTax::setCode()
     * @uses TicketTax::setCountryCode()
     * @uses TicketTax::setSaleCurrencyAmount()
     * @param string $code
     * @param string $countryCode
     * @param float $saleCurrencyAmount
     */
    public function __construct($code = null, $countryCode = null, $saleCurrencyAmount = null)
    {
        $this
            ->setCode($code)
            ->setCountryCode($countryCode)
            ->setSaleCurrencyAmount($saleCurrencyAmount);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \App|C\StructType\TicketTax
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \App|C\StructType\TicketTax
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyAmount value
     * @return float|null
     */
    public function getSaleCurrencyAmount()
    {
        return $this->SaleCurrencyAmount;
    }
    /**
     * Set SaleCurrencyAmount value
     * @param float $saleCurrencyAmount
     * @return \App|C\StructType\TicketTax
     */
    public function setSaleCurrencyAmount($saleCurrencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($saleCurrencyAmount) && !(is_float($saleCurrencyAmount) || is_numeric($saleCurrencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleCurrencyAmount, true), gettype($saleCurrencyAmount)), __LINE__);
        }
        $this->SaleCurrencyAmount = $saleCurrencyAmount;
        return $this;
    }
}
