<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiError StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApiError
 * @subpackage Structs
 */
class ApiError extends Notification
{
    /**
     * The FullText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullText;
    /**
     * The RecordId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordId;
    /**
     * Constructor method for ApiError
     * @uses ApiError::setFullText()
     * @uses ApiError::setRecordId()
     * @param string $fullText
     * @param string $recordId
     */
    public function __construct($fullText = null, $recordId = null)
    {
        $this
            ->setFullText($fullText)
            ->setRecordId($recordId);
    }
    /**
     * Get FullText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullText()
    {
        return isset($this->FullText) ? $this->FullText : null;
    }
    /**
     * Set FullText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullText
     * @return \App|C\StructType\ApiError
     */
    public function setFullText($fullText = null)
    {
        // validation for constraint: string
        if (!is_null($fullText) && !is_string($fullText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullText, true), gettype($fullText)), __LINE__);
        }
        if (is_null($fullText) || (is_array($fullText) && empty($fullText))) {
            unset($this->FullText);
        } else {
            $this->FullText = $fullText;
        }
        return $this;
    }
    /**
     * Get RecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordId()
    {
        return isset($this->RecordId) ? $this->RecordId : null;
    }
    /**
     * Set RecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordId
     * @return \App|C\StructType\ApiError
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        if (is_null($recordId) || (is_array($recordId) && empty($recordId))) {
            unset($this->RecordId);
        } else {
            $this->RecordId = $recordId;
        }
        return $this;
    }
}
