<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPrivateReference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerPrivateReference
 * @subpackage Structs
 */
class CustomerPrivateReference extends ApiObject
{
    /**
     * The CustomerTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerTypeCode;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Login;
    /**
     * The RefCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefCustomer;
    /**
     * Constructor method for CustomerPrivateReference
     * @uses CustomerPrivateReference::setCustomerTypeCode()
     * @uses CustomerPrivateReference::setLogin()
     * @uses CustomerPrivateReference::setRefCustomer()
     * @param string $customerTypeCode
     * @param string $login
     * @param string $refCustomer
     */
    public function __construct($customerTypeCode = null, $login = null, $refCustomer = null)
    {
        $this
            ->setCustomerTypeCode($customerTypeCode)
            ->setLogin($login)
            ->setRefCustomer($refCustomer);
    }
    /**
     * Get CustomerTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerTypeCode()
    {
        return isset($this->CustomerTypeCode) ? $this->CustomerTypeCode : null;
    }
    /**
     * Set CustomerTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerTypeCode
     * @return \App|C\StructType\CustomerPrivateReference
     */
    public function setCustomerTypeCode($customerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerTypeCode) && !is_string($customerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTypeCode, true), gettype($customerTypeCode)), __LINE__);
        }
        if (is_null($customerTypeCode) || (is_array($customerTypeCode) && empty($customerTypeCode))) {
            unset($this->CustomerTypeCode);
        } else {
            $this->CustomerTypeCode = $customerTypeCode;
        }
        return $this;
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \App|C\StructType\CustomerPrivateReference
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Get RefCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefCustomer()
    {
        return isset($this->RefCustomer) ? $this->RefCustomer : null;
    }
    /**
     * Set RefCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refCustomer
     * @return \App|C\StructType\CustomerPrivateReference
     */
    public function setRefCustomer($refCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($refCustomer) && !is_string($refCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCustomer, true), gettype($refCustomer)), __LINE__);
        }
        if (is_null($refCustomer) || (is_array($refCustomer) && empty($refCustomer))) {
            unset($this->RefCustomer);
        } else {
            $this->RefCustomer = $refCustomer;
        }
        return $this;
    }
}
