<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractRequest
 * @subpackage Structs
 */
class AbstractRequest extends ApiObject
{
    /**
     * The RequestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\RequestInfo
     */
    public $RequestInfo;
    /**
     * Constructor method for AbstractRequest
     * @uses AbstractRequest::setRequestInfo()
     * @param \App|C\StructType\RequestInfo $requestInfo
     */
    public function __construct(\App|C\StructType\RequestInfo $requestInfo = null)
    {
        $this
            ->setRequestInfo($requestInfo);
    }
    /**
     * Get RequestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\RequestInfo|null
     */
    public function getRequestInfo()
    {
        return isset($this->RequestInfo) ? $this->RequestInfo : null;
    }
    /**
     * Set RequestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\RequestInfo $requestInfo
     * @return \App|C\StructType\AbstractRequest
     */
    public function setRequestInfo(\App|C\StructType\RequestInfo $requestInfo = null)
    {
        if (is_null($requestInfo) || (is_array($requestInfo) && empty($requestInfo))) {
            unset($this->RequestInfo);
        } else {
            $this->RequestInfo = $requestInfo;
        }
        return $this;
    }
}
