<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORGIssuanceInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ORGIssuanceInfo
 * @subpackage Structs
 */
class ORGIssuanceInfo extends ApiObject
{
    /**
     * The AuthorityRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorityRequest;
    /**
     * The CommunicationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommunicationNumber;
    /**
     * The OriginatorCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorCountryCode;
    /**
     * The OriginatorInHouseIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorInHouseIdentification;
    /**
     * The OriginatorIssuingCountryCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorIssuingCountryCurrency;
    /**
     * The OriginatorLanguage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorLanguage;
    /**
     * The OriginatorLocationIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginatorLocationIdentification;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartyIdentification;
    /**
     * The SystemAirlineDesignator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemAirlineDesignator;
    /**
     * The SystemLocationIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemLocationIdentification;
    /**
     * The TravelAgencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TravelAgencyCode;
    /**
     * Constructor method for ORGIssuanceInfo
     * @uses ORGIssuanceInfo::setAuthorityRequest()
     * @uses ORGIssuanceInfo::setCommunicationNumber()
     * @uses ORGIssuanceInfo::setOriginatorCountryCode()
     * @uses ORGIssuanceInfo::setOriginatorInHouseIdentification()
     * @uses ORGIssuanceInfo::setOriginatorIssuingCountryCurrency()
     * @uses ORGIssuanceInfo::setOriginatorLanguage()
     * @uses ORGIssuanceInfo::setOriginatorLocationIdentification()
     * @uses ORGIssuanceInfo::setPartyIdentification()
     * @uses ORGIssuanceInfo::setSystemAirlineDesignator()
     * @uses ORGIssuanceInfo::setSystemLocationIdentification()
     * @uses ORGIssuanceInfo::setTravelAgencyCode()
     * @param string $authorityRequest
     * @param string $communicationNumber
     * @param string $originatorCountryCode
     * @param string $originatorInHouseIdentification
     * @param string $originatorIssuingCountryCurrency
     * @param string $originatorLanguage
     * @param string $originatorLocationIdentification
     * @param string $partyIdentification
     * @param string $systemAirlineDesignator
     * @param string $systemLocationIdentification
     * @param string $travelAgencyCode
     */
    public function __construct($authorityRequest = null, $communicationNumber = null, $originatorCountryCode = null, $originatorInHouseIdentification = null, $originatorIssuingCountryCurrency = null, $originatorLanguage = null, $originatorLocationIdentification = null, $partyIdentification = null, $systemAirlineDesignator = null, $systemLocationIdentification = null, $travelAgencyCode = null)
    {
        $this
            ->setAuthorityRequest($authorityRequest)
            ->setCommunicationNumber($communicationNumber)
            ->setOriginatorCountryCode($originatorCountryCode)
            ->setOriginatorInHouseIdentification($originatorInHouseIdentification)
            ->setOriginatorIssuingCountryCurrency($originatorIssuingCountryCurrency)
            ->setOriginatorLanguage($originatorLanguage)
            ->setOriginatorLocationIdentification($originatorLocationIdentification)
            ->setPartyIdentification($partyIdentification)
            ->setSystemAirlineDesignator($systemAirlineDesignator)
            ->setSystemLocationIdentification($systemLocationIdentification)
            ->setTravelAgencyCode($travelAgencyCode);
    }
    /**
     * Get AuthorityRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorityRequest()
    {
        return isset($this->AuthorityRequest) ? $this->AuthorityRequest : null;
    }
    /**
     * Set AuthorityRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorityRequest
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setAuthorityRequest($authorityRequest = null)
    {
        // validation for constraint: string
        if (!is_null($authorityRequest) && !is_string($authorityRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorityRequest, true), gettype($authorityRequest)), __LINE__);
        }
        if (is_null($authorityRequest) || (is_array($authorityRequest) && empty($authorityRequest))) {
            unset($this->AuthorityRequest);
        } else {
            $this->AuthorityRequest = $authorityRequest;
        }
        return $this;
    }
    /**
     * Get CommunicationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationNumber()
    {
        return isset($this->CommunicationNumber) ? $this->CommunicationNumber : null;
    }
    /**
     * Set CommunicationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationNumber
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setCommunicationNumber($communicationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($communicationNumber) && !is_string($communicationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationNumber, true), gettype($communicationNumber)), __LINE__);
        }
        if (is_null($communicationNumber) || (is_array($communicationNumber) && empty($communicationNumber))) {
            unset($this->CommunicationNumber);
        } else {
            $this->CommunicationNumber = $communicationNumber;
        }
        return $this;
    }
    /**
     * Get OriginatorCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorCountryCode()
    {
        return isset($this->OriginatorCountryCode) ? $this->OriginatorCountryCode : null;
    }
    /**
     * Set OriginatorCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorCountryCode
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setOriginatorCountryCode($originatorCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($originatorCountryCode) && !is_string($originatorCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorCountryCode, true), gettype($originatorCountryCode)), __LINE__);
        }
        if (is_null($originatorCountryCode) || (is_array($originatorCountryCode) && empty($originatorCountryCode))) {
            unset($this->OriginatorCountryCode);
        } else {
            $this->OriginatorCountryCode = $originatorCountryCode;
        }
        return $this;
    }
    /**
     * Get OriginatorInHouseIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorInHouseIdentification()
    {
        return isset($this->OriginatorInHouseIdentification) ? $this->OriginatorInHouseIdentification : null;
    }
    /**
     * Set OriginatorInHouseIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorInHouseIdentification
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setOriginatorInHouseIdentification($originatorInHouseIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($originatorInHouseIdentification) && !is_string($originatorInHouseIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorInHouseIdentification, true), gettype($originatorInHouseIdentification)), __LINE__);
        }
        if (is_null($originatorInHouseIdentification) || (is_array($originatorInHouseIdentification) && empty($originatorInHouseIdentification))) {
            unset($this->OriginatorInHouseIdentification);
        } else {
            $this->OriginatorInHouseIdentification = $originatorInHouseIdentification;
        }
        return $this;
    }
    /**
     * Get OriginatorIssuingCountryCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorIssuingCountryCurrency()
    {
        return isset($this->OriginatorIssuingCountryCurrency) ? $this->OriginatorIssuingCountryCurrency : null;
    }
    /**
     * Set OriginatorIssuingCountryCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorIssuingCountryCurrency
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setOriginatorIssuingCountryCurrency($originatorIssuingCountryCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originatorIssuingCountryCurrency) && !is_string($originatorIssuingCountryCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorIssuingCountryCurrency, true), gettype($originatorIssuingCountryCurrency)), __LINE__);
        }
        if (is_null($originatorIssuingCountryCurrency) || (is_array($originatorIssuingCountryCurrency) && empty($originatorIssuingCountryCurrency))) {
            unset($this->OriginatorIssuingCountryCurrency);
        } else {
            $this->OriginatorIssuingCountryCurrency = $originatorIssuingCountryCurrency;
        }
        return $this;
    }
    /**
     * Get OriginatorLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorLanguage()
    {
        return isset($this->OriginatorLanguage) ? $this->OriginatorLanguage : null;
    }
    /**
     * Set OriginatorLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorLanguage
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setOriginatorLanguage($originatorLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($originatorLanguage) && !is_string($originatorLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorLanguage, true), gettype($originatorLanguage)), __LINE__);
        }
        if (is_null($originatorLanguage) || (is_array($originatorLanguage) && empty($originatorLanguage))) {
            unset($this->OriginatorLanguage);
        } else {
            $this->OriginatorLanguage = $originatorLanguage;
        }
        return $this;
    }
    /**
     * Get OriginatorLocationIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorLocationIdentification()
    {
        return isset($this->OriginatorLocationIdentification) ? $this->OriginatorLocationIdentification : null;
    }
    /**
     * Set OriginatorLocationIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorLocationIdentification
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setOriginatorLocationIdentification($originatorLocationIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($originatorLocationIdentification) && !is_string($originatorLocationIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorLocationIdentification, true), gettype($originatorLocationIdentification)), __LINE__);
        }
        if (is_null($originatorLocationIdentification) || (is_array($originatorLocationIdentification) && empty($originatorLocationIdentification))) {
            unset($this->OriginatorLocationIdentification);
        } else {
            $this->OriginatorLocationIdentification = $originatorLocationIdentification;
        }
        return $this;
    }
    /**
     * Get PartyIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyIdentification()
    {
        return isset($this->PartyIdentification) ? $this->PartyIdentification : null;
    }
    /**
     * Set PartyIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyIdentification
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setPartyIdentification($partyIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($partyIdentification) && !is_string($partyIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyIdentification, true), gettype($partyIdentification)), __LINE__);
        }
        if (is_null($partyIdentification) || (is_array($partyIdentification) && empty($partyIdentification))) {
            unset($this->PartyIdentification);
        } else {
            $this->PartyIdentification = $partyIdentification;
        }
        return $this;
    }
    /**
     * Get SystemAirlineDesignator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemAirlineDesignator()
    {
        return isset($this->SystemAirlineDesignator) ? $this->SystemAirlineDesignator : null;
    }
    /**
     * Set SystemAirlineDesignator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemAirlineDesignator
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setSystemAirlineDesignator($systemAirlineDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($systemAirlineDesignator) && !is_string($systemAirlineDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemAirlineDesignator, true), gettype($systemAirlineDesignator)), __LINE__);
        }
        if (is_null($systemAirlineDesignator) || (is_array($systemAirlineDesignator) && empty($systemAirlineDesignator))) {
            unset($this->SystemAirlineDesignator);
        } else {
            $this->SystemAirlineDesignator = $systemAirlineDesignator;
        }
        return $this;
    }
    /**
     * Get SystemLocationIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemLocationIdentification()
    {
        return isset($this->SystemLocationIdentification) ? $this->SystemLocationIdentification : null;
    }
    /**
     * Set SystemLocationIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemLocationIdentification
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setSystemLocationIdentification($systemLocationIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($systemLocationIdentification) && !is_string($systemLocationIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemLocationIdentification, true), gettype($systemLocationIdentification)), __LINE__);
        }
        if (is_null($systemLocationIdentification) || (is_array($systemLocationIdentification) && empty($systemLocationIdentification))) {
            unset($this->SystemLocationIdentification);
        } else {
            $this->SystemLocationIdentification = $systemLocationIdentification;
        }
        return $this;
    }
    /**
     * Get TravelAgencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTravelAgencyCode()
    {
        return isset($this->TravelAgencyCode) ? $this->TravelAgencyCode : null;
    }
    /**
     * Set TravelAgencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $travelAgencyCode
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public function setTravelAgencyCode($travelAgencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyCode) && !is_string($travelAgencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelAgencyCode, true), gettype($travelAgencyCode)), __LINE__);
        }
        if (is_null($travelAgencyCode) || (is_array($travelAgencyCode) && empty($travelAgencyCode))) {
            unset($this->TravelAgencyCode);
        } else {
            $this->TravelAgencyCode = $travelAgencyCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ORGIssuanceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
