<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetValueCodesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetValueCodesRequest
 * @subpackage Structs
 */
class GetValueCodesRequest extends AbstractRequest
{
    /**
     * The ValueCodeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueCodeName;
    /**
     * Constructor method for GetValueCodesRequest
     * @uses GetValueCodesRequest::setValueCodeName()
     * @param string $valueCodeName
     */
    public function __construct($valueCodeName = null)
    {
        $this
            ->setValueCodeName($valueCodeName);
    }
    /**
     * Get ValueCodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueCodeName()
    {
        return isset($this->ValueCodeName) ? $this->ValueCodeName : null;
    }
    /**
     * Set ValueCodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueCodeName
     * @return \App|C\StructType\GetValueCodesRequest
     */
    public function setValueCodeName($valueCodeName = null)
    {
        // validation for constraint: string
        if (!is_null($valueCodeName) && !is_string($valueCodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueCodeName, true), gettype($valueCodeName)), __LINE__);
        }
        if (is_null($valueCodeName) || (is_array($valueCodeName) && empty($valueCodeName))) {
            unset($this->ValueCodeName);
        } else {
            $this->ValueCodeName = $valueCodeName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\GetValueCodesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
