<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlownCouponsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlownCouponsRequest
 * @subpackage Structs
 */
class FlownCouponsRequest extends AbstractRequest
{
    /**
     * The AwardableCouponsOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AwardableCouponsOnly;
    /**
     * The EndFlightDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndFlightDate;
    /**
     * The StartFlightDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartFlightDate;
    /**
     * Constructor method for FlownCouponsRequest
     * @uses FlownCouponsRequest::setAwardableCouponsOnly()
     * @uses FlownCouponsRequest::setEndFlightDate()
     * @uses FlownCouponsRequest::setStartFlightDate()
     * @param bool $awardableCouponsOnly
     * @param string $endFlightDate
     * @param string $startFlightDate
     */
    public function __construct($awardableCouponsOnly = null, $endFlightDate = null, $startFlightDate = null)
    {
        $this
            ->setAwardableCouponsOnly($awardableCouponsOnly)
            ->setEndFlightDate($endFlightDate)
            ->setStartFlightDate($startFlightDate);
    }
    /**
     * Get AwardableCouponsOnly value
     * @return bool|null
     */
    public function getAwardableCouponsOnly()
    {
        return $this->AwardableCouponsOnly;
    }
    /**
     * Set AwardableCouponsOnly value
     * @param bool $awardableCouponsOnly
     * @return \App|C\StructType\FlownCouponsRequest
     */
    public function setAwardableCouponsOnly($awardableCouponsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($awardableCouponsOnly) && !is_bool($awardableCouponsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($awardableCouponsOnly, true), gettype($awardableCouponsOnly)), __LINE__);
        }
        $this->AwardableCouponsOnly = $awardableCouponsOnly;
        return $this;
    }
    /**
     * Get EndFlightDate value
     * @return string|null
     */
    public function getEndFlightDate()
    {
        return $this->EndFlightDate;
    }
    /**
     * Set EndFlightDate value
     * @param string $endFlightDate
     * @return \App|C\StructType\FlownCouponsRequest
     */
    public function setEndFlightDate($endFlightDate = null)
    {
        // validation for constraint: string
        if (!is_null($endFlightDate) && !is_string($endFlightDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endFlightDate, true), gettype($endFlightDate)), __LINE__);
        }
        $this->EndFlightDate = $endFlightDate;
        return $this;
    }
    /**
     * Get StartFlightDate value
     * @return string|null
     */
    public function getStartFlightDate()
    {
        return $this->StartFlightDate;
    }
    /**
     * Set StartFlightDate value
     * @param string $startFlightDate
     * @return \App|C\StructType\FlownCouponsRequest
     */
    public function setStartFlightDate($startFlightDate = null)
    {
        // validation for constraint: string
        if (!is_null($startFlightDate) && !is_string($startFlightDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startFlightDate, true), gettype($startFlightDate)), __LINE__);
        }
        $this->StartFlightDate = $startFlightDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FlownCouponsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
