<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MiscInfo
 * @subpackage Structs
 */
class MiscInfo extends ApiObject
{
    /**
     * The BoardingPassList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfBoardingPassInfo
     */
    public $BoardingPassList;
    /**
     * The CancelInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CancelInfo
     */
    public $CancelInfo;
    /**
     * The ExchangeableOriginDestinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfExchangeableOriginDestination
     */
    public $ExchangeableOriginDestinations;
    /**
     * The IsPendingExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPendingExchange;
    /**
     * The PendingRefundRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\RefundRequestInfo
     */
    public $PendingRefundRequest;
    /**
     * Constructor method for MiscInfo
     * @uses MiscInfo::setBoardingPassList()
     * @uses MiscInfo::setCancelInfo()
     * @uses MiscInfo::setExchangeableOriginDestinations()
     * @uses MiscInfo::setIsPendingExchange()
     * @uses MiscInfo::setPendingRefundRequest()
     * @param \App|C\ArrayType\ArrayOfBoardingPassInfo $boardingPassList
     * @param \App|C\StructType\CancelInfo $cancelInfo
     * @param \App|C\ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations
     * @param bool $isPendingExchange
     * @param \App|C\StructType\RefundRequestInfo $pendingRefundRequest
     */
    public function __construct(\App|C\ArrayType\ArrayOfBoardingPassInfo $boardingPassList = null, \App|C\StructType\CancelInfo $cancelInfo = null, \App|C\ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations = null, $isPendingExchange = null, \App|C\StructType\RefundRequestInfo $pendingRefundRequest = null)
    {
        $this
            ->setBoardingPassList($boardingPassList)
            ->setCancelInfo($cancelInfo)
            ->setExchangeableOriginDestinations($exchangeableOriginDestinations)
            ->setIsPendingExchange($isPendingExchange)
            ->setPendingRefundRequest($pendingRefundRequest);
    }
    /**
     * Get BoardingPassList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfBoardingPassInfo|null
     */
    public function getBoardingPassList()
    {
        return isset($this->BoardingPassList) ? $this->BoardingPassList : null;
    }
    /**
     * Set BoardingPassList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfBoardingPassInfo $boardingPassList
     * @return \App|C\StructType\MiscInfo
     */
    public function setBoardingPassList(\App|C\ArrayType\ArrayOfBoardingPassInfo $boardingPassList = null)
    {
        if (is_null($boardingPassList) || (is_array($boardingPassList) && empty($boardingPassList))) {
            unset($this->BoardingPassList);
        } else {
            $this->BoardingPassList = $boardingPassList;
        }
        return $this;
    }
    /**
     * Get CancelInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CancelInfo|null
     */
    public function getCancelInfo()
    {
        return isset($this->CancelInfo) ? $this->CancelInfo : null;
    }
    /**
     * Set CancelInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\CancelInfo $cancelInfo
     * @return \App|C\StructType\MiscInfo
     */
    public function setCancelInfo(\App|C\StructType\CancelInfo $cancelInfo = null)
    {
        if (is_null($cancelInfo) || (is_array($cancelInfo) && empty($cancelInfo))) {
            unset($this->CancelInfo);
        } else {
            $this->CancelInfo = $cancelInfo;
        }
        return $this;
    }
    /**
     * Get ExchangeableOriginDestinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfExchangeableOriginDestination|null
     */
    public function getExchangeableOriginDestinations()
    {
        return isset($this->ExchangeableOriginDestinations) ? $this->ExchangeableOriginDestinations : null;
    }
    /**
     * Set ExchangeableOriginDestinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations
     * @return \App|C\StructType\MiscInfo
     */
    public function setExchangeableOriginDestinations(\App|C\ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations = null)
    {
        if (is_null($exchangeableOriginDestinations) || (is_array($exchangeableOriginDestinations) && empty($exchangeableOriginDestinations))) {
            unset($this->ExchangeableOriginDestinations);
        } else {
            $this->ExchangeableOriginDestinations = $exchangeableOriginDestinations;
        }
        return $this;
    }
    /**
     * Get IsPendingExchange value
     * @return bool|null
     */
    public function getIsPendingExchange()
    {
        return $this->IsPendingExchange;
    }
    /**
     * Set IsPendingExchange value
     * @param bool $isPendingExchange
     * @return \App|C\StructType\MiscInfo
     */
    public function setIsPendingExchange($isPendingExchange = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPendingExchange) && !is_bool($isPendingExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPendingExchange, true), gettype($isPendingExchange)), __LINE__);
        }
        $this->IsPendingExchange = $isPendingExchange;
        return $this;
    }
    /**
     * Get PendingRefundRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\RefundRequestInfo|null
     */
    public function getPendingRefundRequest()
    {
        return isset($this->PendingRefundRequest) ? $this->PendingRefundRequest : null;
    }
    /**
     * Set PendingRefundRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\RefundRequestInfo $pendingRefundRequest
     * @return \App|C\StructType\MiscInfo
     */
    public function setPendingRefundRequest(\App|C\StructType\RefundRequestInfo $pendingRefundRequest = null)
    {
        if (is_null($pendingRefundRequest) || (is_array($pendingRefundRequest) && empty($pendingRefundRequest))) {
            unset($this->PendingRefundRequest);
        } else {
            $this->PendingRefundRequest = $pendingRefundRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\MiscInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
