<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageContext StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MessageContext
 * @subpackage Structs
 */
class MessageContext extends AbstractStructBase
{
    /**
     * The RequestGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * - use: required
     * @var string
     */
    public $RequestGuid;
    /**
     * The Channel
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Channel;
    /**
     * The Referer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App|C\StructType\MessageReferer
     */
    public $Referer;
    /**
     * The Identities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App|C\StructType\ArrayOfMessageIdentity
     */
    public $Identities;
    /**
     * The RequestTraceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestTraceInfo;
    /**
     * The CultureName
     * @var string
     */
    public $CultureName;
    /**
     * The EnvName
     * @var string
     */
    public $EnvName;
    /**
     * The _identities
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \App|C\StructType\ArrayOfMessageIdentity
     */
    public $_identities;
    /**
     * The _requestGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $_requestGuid;
    /**
     * The _x003C_Channel_x003E_k__BackingField
     * @var string
     */
    public $_x003C_Channel_x003E_k__BackingField;
    /**
     * The _x003C_CultureName_x003E_k__BackingField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $_x003C_CultureName_x003E_k__BackingField;
    /**
     * The _x003C_EnvName_x003E_k__BackingField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $_x003C_EnvName_x003E_k__BackingField;
    /**
     * The _x003C_Referer_x003E_k__BackingField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \App|C\StructType\MessageReferer
     */
    public $_x003C_Referer_x003E_k__BackingField;
    /**
     * The _x003C_RequestTraceInfo_x003E_k__BackingField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $_x003C_RequestTraceInfo_x003E_k__BackingField;
    /**
     * Constructor method for MessageContext
     * @uses MessageContext::setRequestGuid()
     * @uses MessageContext::setChannel()
     * @uses MessageContext::setReferer()
     * @uses MessageContext::setIdentities()
     * @uses MessageContext::setRequestTraceInfo()
     * @uses MessageContext::setCultureName()
     * @uses MessageContext::setEnvName()
     * @uses MessageContext::set_identities()
     * @uses MessageContext::set_requestGuid()
     * @uses MessageContext::set_x003C_Channel_x003E_k__BackingField()
     * @uses MessageContext::set_x003C_CultureName_x003E_k__BackingField()
     * @uses MessageContext::set_x003C_EnvName_x003E_k__BackingField()
     * @uses MessageContext::set_x003C_Referer_x003E_k__BackingField()
     * @uses MessageContext::set_x003C_RequestTraceInfo_x003E_k__BackingField()
     * @param string $requestGuid
     * @param string $channel
     * @param \App|C\StructType\MessageReferer $referer
     * @param \App|C\StructType\ArrayOfMessageIdentity $identities
     * @param string $requestTraceInfo
     * @param string $cultureName
     * @param string $envName
     * @param \App|C\StructType\ArrayOfMessageIdentity $_identities
     * @param string $_requestGuid
     * @param string $_x003C_Channel_x003E_k__BackingField
     * @param string $_x003C_CultureName_x003E_k__BackingField
     * @param string $_x003C_EnvName_x003E_k__BackingField
     * @param \App|C\StructType\MessageReferer $_x003C_Referer_x003E_k__BackingField
     * @param string $_x003C_RequestTraceInfo_x003E_k__BackingField
     */
    public function __construct($requestGuid = null, $channel = null, \App|C\StructType\MessageReferer $referer = null, \App|C\StructType\ArrayOfMessageIdentity $identities = null, $requestTraceInfo = null, $cultureName = null, $envName = null, \App|C\StructType\ArrayOfMessageIdentity $_identities = null, $_requestGuid = null, $_x003C_Channel_x003E_k__BackingField = null, $_x003C_CultureName_x003E_k__BackingField = null, $_x003C_EnvName_x003E_k__BackingField = null, \App|C\StructType\MessageReferer $_x003C_Referer_x003E_k__BackingField = null, $_x003C_RequestTraceInfo_x003E_k__BackingField = null)
    {
        $this
            ->setRequestGuid($requestGuid)
            ->setChannel($channel)
            ->setReferer($referer)
            ->setIdentities($identities)
            ->setRequestTraceInfo($requestTraceInfo)
            ->setCultureName($cultureName)
            ->setEnvName($envName)
            ->set_identities($_identities)
            ->set_requestGuid($_requestGuid)
            ->set_x003C_Channel_x003E_k__BackingField($_x003C_Channel_x003E_k__BackingField)
            ->set_x003C_CultureName_x003E_k__BackingField($_x003C_CultureName_x003E_k__BackingField)
            ->set_x003C_EnvName_x003E_k__BackingField($_x003C_EnvName_x003E_k__BackingField)
            ->set_x003C_Referer_x003E_k__BackingField($_x003C_Referer_x003E_k__BackingField)
            ->set_x003C_RequestTraceInfo_x003E_k__BackingField($_x003C_RequestTraceInfo_x003E_k__BackingField);
    }
    /**
     * Get RequestGuid value
     * @return string
     */
    public function getRequestGuid()
    {
        return $this->RequestGuid;
    }
    /**
     * Set RequestGuid value
     * @param string $requestGuid
     * @return \App|C\StructType\MessageContext
     */
    public function setRequestGuid($requestGuid = null)
    {
        // validation for constraint: string
        if (!is_null($requestGuid) && !is_string($requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestGuid, true), gettype($requestGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestGuid, true)), __LINE__);
        }
        $this->RequestGuid = $requestGuid;
        return $this;
    }
    /**
     * Get Channel value
     * @return string
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \App|C\EnumType\DistributionChannel::valueIsValid()
     * @uses \App|C\EnumType\DistributionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \App|C\StructType\MessageContext
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\App|C\EnumType\DistributionChannel::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App|C\EnumType\DistributionChannel', is_array($channel) ? implode(', ', $channel) : var_export($channel, true), implode(', ', \App|C\EnumType\DistributionChannel::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Referer value
     * @return \App|C\StructType\MessageReferer|null
     */
    public function getReferer()
    {
        return $this->Referer;
    }
    /**
     * Set Referer value
     * @param \App|C\StructType\MessageReferer $referer
     * @return \App|C\StructType\MessageContext
     */
    public function setReferer(\App|C\StructType\MessageReferer $referer = null)
    {
        $this->Referer = $referer;
        return $this;
    }
    /**
     * Get Identities value
     * @return \App|C\StructType\ArrayOfMessageIdentity|null
     */
    public function getIdentities()
    {
        return $this->Identities;
    }
    /**
     * Set Identities value
     * @param \App|C\StructType\ArrayOfMessageIdentity $identities
     * @return \App|C\StructType\MessageContext
     */
    public function setIdentities(\App|C\StructType\ArrayOfMessageIdentity $identities = null)
    {
        $this->Identities = $identities;
        return $this;
    }
    /**
     * Get RequestTraceInfo value
     * @return string|null
     */
    public function getRequestTraceInfo()
    {
        return $this->RequestTraceInfo;
    }
    /**
     * Set RequestTraceInfo value
     * @param string $requestTraceInfo
     * @return \App|C\StructType\MessageContext
     */
    public function setRequestTraceInfo($requestTraceInfo = null)
    {
        // validation for constraint: string
        if (!is_null($requestTraceInfo) && !is_string($requestTraceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTraceInfo, true), gettype($requestTraceInfo)), __LINE__);
        }
        $this->RequestTraceInfo = $requestTraceInfo;
        return $this;
    }
    /**
     * Get CultureName value
     * @return string|null
     */
    public function getCultureName()
    {
        return $this->CultureName;
    }
    /**
     * Set CultureName value
     * @param string $cultureName
     * @return \App|C\StructType\MessageContext
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        $this->CultureName = $cultureName;
        return $this;
    }
    /**
     * Get EnvName value
     * @return string|null
     */
    public function getEnvName()
    {
        return $this->EnvName;
    }
    /**
     * Set EnvName value
     * @param string $envName
     * @return \App|C\StructType\MessageContext
     */
    public function setEnvName($envName = null)
    {
        // validation for constraint: string
        if (!is_null($envName) && !is_string($envName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envName, true), gettype($envName)), __LINE__);
        }
        $this->EnvName = $envName;
        return $this;
    }
    /**
     * Get _identities value
     * @return \App|C\StructType\ArrayOfMessageIdentity|null
     */
    public function get_identities()
    {
        return $this->_identities;
    }
    /**
     * Set _identities value
     * @param \App|C\StructType\ArrayOfMessageIdentity $_identities
     * @return \App|C\StructType\MessageContext
     */
    public function set_identities(\App|C\StructType\ArrayOfMessageIdentity $_identities = null)
    {
        $this->_identities = $_identities;
        return $this;
    }
    /**
     * Get _requestGuid value
     * @return string|null
     */
    public function get_requestGuid()
    {
        return $this->_requestGuid;
    }
    /**
     * Set _requestGuid value
     * @param string $_requestGuid
     * @return \App|C\StructType\MessageContext
     */
    public function set_requestGuid($_requestGuid = null)
    {
        // validation for constraint: string
        if (!is_null($_requestGuid) && !is_string($_requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_requestGuid, true), gettype($_requestGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($_requestGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $_requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($_requestGuid, true)), __LINE__);
        }
        $this->_requestGuid = $_requestGuid;
        return $this;
    }
    /**
     * Get _x003C_Channel_x003E_k__BackingField value
     * @return string|null
     */
    public function get_x003C_Channel_x003E_k__BackingField()
    {
        return $this->_x003C_Channel_x003E_k__BackingField;
    }
    /**
     * Set _x003C_Channel_x003E_k__BackingField value
     * @uses \App|C\EnumType\DistributionChannel::valueIsValid()
     * @uses \App|C\EnumType\DistributionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $_x003C_Channel_x003E_k__BackingField
     * @return \App|C\StructType\MessageContext
     */
    public function set_x003C_Channel_x003E_k__BackingField($_x003C_Channel_x003E_k__BackingField = null)
    {
        // validation for constraint: enumeration
        if (!\App|C\EnumType\DistributionChannel::valueIsValid($_x003C_Channel_x003E_k__BackingField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App|C\EnumType\DistributionChannel', is_array($_x003C_Channel_x003E_k__BackingField) ? implode(', ', $_x003C_Channel_x003E_k__BackingField) : var_export($_x003C_Channel_x003E_k__BackingField, true), implode(', ', \App|C\EnumType\DistributionChannel::getValidValues())), __LINE__);
        }
        $this->_x003C_Channel_x003E_k__BackingField = $_x003C_Channel_x003E_k__BackingField;
        return $this;
    }
    /**
     * Get _x003C_CultureName_x003E_k__BackingField value
     * @return string|null
     */
    public function get_x003C_CultureName_x003E_k__BackingField()
    {
        return $this->_x003C_CultureName_x003E_k__BackingField;
    }
    /**
     * Set _x003C_CultureName_x003E_k__BackingField value
     * @param string $_x003C_CultureName_x003E_k__BackingField
     * @return \App|C\StructType\MessageContext
     */
    public function set_x003C_CultureName_x003E_k__BackingField($_x003C_CultureName_x003E_k__BackingField = null)
    {
        // validation for constraint: string
        if (!is_null($_x003C_CultureName_x003E_k__BackingField) && !is_string($_x003C_CultureName_x003E_k__BackingField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_x003C_CultureName_x003E_k__BackingField, true), gettype($_x003C_CultureName_x003E_k__BackingField)), __LINE__);
        }
        $this->_x003C_CultureName_x003E_k__BackingField = $_x003C_CultureName_x003E_k__BackingField;
        return $this;
    }
    /**
     * Get _x003C_EnvName_x003E_k__BackingField value
     * @return string|null
     */
    public function get_x003C_EnvName_x003E_k__BackingField()
    {
        return $this->_x003C_EnvName_x003E_k__BackingField;
    }
    /**
     * Set _x003C_EnvName_x003E_k__BackingField value
     * @param string $_x003C_EnvName_x003E_k__BackingField
     * @return \App|C\StructType\MessageContext
     */
    public function set_x003C_EnvName_x003E_k__BackingField($_x003C_EnvName_x003E_k__BackingField = null)
    {
        // validation for constraint: string
        if (!is_null($_x003C_EnvName_x003E_k__BackingField) && !is_string($_x003C_EnvName_x003E_k__BackingField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_x003C_EnvName_x003E_k__BackingField, true), gettype($_x003C_EnvName_x003E_k__BackingField)), __LINE__);
        }
        $this->_x003C_EnvName_x003E_k__BackingField = $_x003C_EnvName_x003E_k__BackingField;
        return $this;
    }
    /**
     * Get _x003C_Referer_x003E_k__BackingField value
     * @return \App|C\StructType\MessageReferer|null
     */
    public function get_x003C_Referer_x003E_k__BackingField()
    {
        return $this->_x003C_Referer_x003E_k__BackingField;
    }
    /**
     * Set _x003C_Referer_x003E_k__BackingField value
     * @param \App|C\StructType\MessageReferer $_x003C_Referer_x003E_k__BackingField
     * @return \App|C\StructType\MessageContext
     */
    public function set_x003C_Referer_x003E_k__BackingField(\App|C\StructType\MessageReferer $_x003C_Referer_x003E_k__BackingField = null)
    {
        $this->_x003C_Referer_x003E_k__BackingField = $_x003C_Referer_x003E_k__BackingField;
        return $this;
    }
    /**
     * Get _x003C_RequestTraceInfo_x003E_k__BackingField value
     * @return string|null
     */
    public function get_x003C_RequestTraceInfo_x003E_k__BackingField()
    {
        return $this->_x003C_RequestTraceInfo_x003E_k__BackingField;
    }
    /**
     * Set _x003C_RequestTraceInfo_x003E_k__BackingField value
     * @param string $_x003C_RequestTraceInfo_x003E_k__BackingField
     * @return \App|C\StructType\MessageContext
     */
    public function set_x003C_RequestTraceInfo_x003E_k__BackingField($_x003C_RequestTraceInfo_x003E_k__BackingField = null)
    {
        // validation for constraint: string
        if (!is_null($_x003C_RequestTraceInfo_x003E_k__BackingField) && !is_string($_x003C_RequestTraceInfo_x003E_k__BackingField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_x003C_RequestTraceInfo_x003E_k__BackingField, true), gettype($_x003C_RequestTraceInfo_x003E_k__BackingField)), __LINE__);
        }
        $this->_x003C_RequestTraceInfo_x003E_k__BackingField = $_x003C_RequestTraceInfo_x003E_k__BackingField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\MessageContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
