<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrayOfMessageIdentity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMessageIdentity
 * @subpackage Structs
 */
class ArrayOfMessageIdentity extends AbstractStructBase
{
    /**
     * The Identity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\MessageIdentity[]
     */
    public $Identity;
    /**
     * The MessageIdentity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\MessageIdentity[]
     */
    public $MessageIdentity;
    /**
     * Constructor method for ArrayOfMessageIdentity
     * @uses ArrayOfMessageIdentity::setIdentity()
     * @uses ArrayOfMessageIdentity::setMessageIdentity()
     * @param \App|C\StructType\MessageIdentity[] $identity
     * @param \App|C\StructType\MessageIdentity[] $messageIdentity
     */
    public function __construct(array $identity = array(), array $messageIdentity = array())
    {
        $this
            ->setIdentity($identity)
            ->setMessageIdentity($messageIdentity);
    }
    /**
     * Get Identity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\MessageIdentity[]|null
     */
    public function getIdentity()
    {
        return isset($this->Identity) ? $this->Identity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentityForArrayConstraintsFromSetIdentity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMessageIdentityIdentityItem) {
            // validation for constraint: itemType
            if (!$arrayOfMessageIdentityIdentityItem instanceof \App|C\StructType\MessageIdentity) {
                $invalidValues[] = is_object($arrayOfMessageIdentityIdentityItem) ? get_class($arrayOfMessageIdentityIdentityItem) : sprintf('%s(%s)', gettype($arrayOfMessageIdentityIdentityItem), var_export($arrayOfMessageIdentityIdentityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Identity property can only contain items of type \App|C\StructType\MessageIdentity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Identity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\MessageIdentity[] $identity
     * @return \App|C\StructType\ArrayOfMessageIdentity
     */
    public function setIdentity(array $identity = array())
    {
        // validation for constraint: array
        if ('' !== ($identityArrayErrorMessage = self::validateIdentityForArrayConstraintsFromSetIdentity($identity))) {
            throw new \InvalidArgumentException($identityArrayErrorMessage, __LINE__);
        }
        if (is_null($identity) || (is_array($identity) && empty($identity))) {
            unset($this->Identity);
        } else {
            $this->Identity = $identity;
        }
        return $this;
    }
    /**
     * Add item to Identity value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\MessageIdentity $item
     * @return \App|C\StructType\ArrayOfMessageIdentity
     */
    public function addToIdentity(\App|C\StructType\MessageIdentity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\MessageIdentity) {
            throw new \InvalidArgumentException(sprintf('The Identity property can only contain items of type \App|C\StructType\MessageIdentity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Identity[] = $item;
        return $this;
    }
    /**
     * Get MessageIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\MessageIdentity[]|null
     */
    public function getMessageIdentity()
    {
        return isset($this->MessageIdentity) ? $this->MessageIdentity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMessageIdentity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessageIdentity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageIdentityForArrayConstraintsFromSetMessageIdentity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMessageIdentityMessageIdentityItem) {
            // validation for constraint: itemType
            if (!$arrayOfMessageIdentityMessageIdentityItem instanceof \App|C\StructType\MessageIdentity) {
                $invalidValues[] = is_object($arrayOfMessageIdentityMessageIdentityItem) ? get_class($arrayOfMessageIdentityMessageIdentityItem) : sprintf('%s(%s)', gettype($arrayOfMessageIdentityMessageIdentityItem), var_export($arrayOfMessageIdentityMessageIdentityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MessageIdentity property can only contain items of type \App|C\StructType\MessageIdentity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MessageIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\MessageIdentity[] $messageIdentity
     * @return \App|C\StructType\ArrayOfMessageIdentity
     */
    public function setMessageIdentity(array $messageIdentity = array())
    {
        // validation for constraint: array
        if ('' !== ($messageIdentityArrayErrorMessage = self::validateMessageIdentityForArrayConstraintsFromSetMessageIdentity($messageIdentity))) {
            throw new \InvalidArgumentException($messageIdentityArrayErrorMessage, __LINE__);
        }
        if (is_null($messageIdentity) || (is_array($messageIdentity) && empty($messageIdentity))) {
            unset($this->MessageIdentity);
        } else {
            $this->MessageIdentity = $messageIdentity;
        }
        return $this;
    }
    /**
     * Add item to MessageIdentity value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\MessageIdentity $item
     * @return \App|C\StructType\ArrayOfMessageIdentity
     */
    public function addToMessageIdentity(\App|C\StructType\MessageIdentity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\MessageIdentity) {
            throw new \InvalidArgumentException(sprintf('The MessageIdentity property can only contain items of type \App|C\StructType\MessageIdentity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MessageIdentity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\ArrayOfMessageIdentity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
