<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AuthenticateCredentials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\AuthenticateCredentials $parameters
     * @return \App|C\StructType\AuthenticateCredentialsResponse|bool
     */
    public function AuthenticateCredentials(\App|C\StructType\AuthenticateCredentials $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AuthenticateCredentials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\AuthenticateCredentialsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
