<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RefundSettings
 * @subpackage Structs
 */
class RefundSettings extends ApiObject
{
    /**
     * The GDSCancelReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GDSCancelReason;
    /**
     * The IgnoreReward
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IgnoreReward;
    /**
     * The RefundAllTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RefundAllTaxes;
    /**
     * The RefundFops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\ArrayType\ArrayOfFop
     */
    public $RefundFops;
    /**
     * Constructor method for RefundSettings
     * @uses RefundSettings::setGDSCancelReason()
     * @uses RefundSettings::setIgnoreReward()
     * @uses RefundSettings::setRefundAllTaxes()
     * @uses RefundSettings::setRefundFops()
     * @param string $gDSCancelReason
     * @param bool $ignoreReward
     * @param bool $refundAllTaxes
     * @param \App|C\ArrayType\ArrayOfFop $refundFops
     */
    public function __construct($gDSCancelReason = null, $ignoreReward = null, $refundAllTaxes = null, \App|C\ArrayType\ArrayOfFop $refundFops = null)
    {
        $this
            ->setGDSCancelReason($gDSCancelReason)
            ->setIgnoreReward($ignoreReward)
            ->setRefundAllTaxes($refundAllTaxes)
            ->setRefundFops($refundFops);
    }
    /**
     * Get GDSCancelReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGDSCancelReason()
    {
        return isset($this->GDSCancelReason) ? $this->GDSCancelReason : null;
    }
    /**
     * Set GDSCancelReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gDSCancelReason
     * @return \App|C\StructType\RefundSettings
     */
    public function setGDSCancelReason($gDSCancelReason = null)
    {
        // validation for constraint: string
        if (!is_null($gDSCancelReason) && !is_string($gDSCancelReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDSCancelReason, true), gettype($gDSCancelReason)), __LINE__);
        }
        if (is_null($gDSCancelReason) || (is_array($gDSCancelReason) && empty($gDSCancelReason))) {
            unset($this->GDSCancelReason);
        } else {
            $this->GDSCancelReason = $gDSCancelReason;
        }
        return $this;
    }
    /**
     * Get IgnoreReward value
     * @return bool|null
     */
    public function getIgnoreReward()
    {
        return $this->IgnoreReward;
    }
    /**
     * Set IgnoreReward value
     * @param bool $ignoreReward
     * @return \App|C\StructType\RefundSettings
     */
    public function setIgnoreReward($ignoreReward = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreReward) && !is_bool($ignoreReward)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreReward, true), gettype($ignoreReward)), __LINE__);
        }
        $this->IgnoreReward = $ignoreReward;
        return $this;
    }
    /**
     * Get RefundAllTaxes value
     * @return bool|null
     */
    public function getRefundAllTaxes()
    {
        return $this->RefundAllTaxes;
    }
    /**
     * Set RefundAllTaxes value
     * @param bool $refundAllTaxes
     * @return \App|C\StructType\RefundSettings
     */
    public function setRefundAllTaxes($refundAllTaxes = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundAllTaxes) && !is_bool($refundAllTaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundAllTaxes, true), gettype($refundAllTaxes)), __LINE__);
        }
        $this->RefundAllTaxes = $refundAllTaxes;
        return $this;
    }
    /**
     * Get RefundFops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\ArrayType\ArrayOfFop|null
     */
    public function getRefundFops()
    {
        return isset($this->RefundFops) ? $this->RefundFops : null;
    }
    /**
     * Set RefundFops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\ArrayType\ArrayOfFop $refundFops
     * @return \App|C\StructType\RefundSettings
     */
    public function setRefundFops(\App|C\ArrayType\ArrayOfFop $refundFops = null)
    {
        if (is_null($refundFops) || (is_array($refundFops) && empty($refundFops))) {
            unset($this->RefundFops);
        } else {
            $this->RefundFops = $refundFops;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\RefundSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
