<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passenger StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Passenger
 * @subpackage Structs
 */
class Passenger extends ApiObject
{
    /**
     * The NameElement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\NameElement
     */
    public $NameElement;
    /**
     * The PassengerQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerQuantity;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * The RefClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefClient;
    /**
     * Constructor method for Passenger
     * @uses Passenger::setNameElement()
     * @uses Passenger::setPassengerQuantity()
     * @uses Passenger::setPassengerTypeCode()
     * @uses Passenger::setRef()
     * @uses Passenger::setRefClient()
     * @param \App|C\StructType\NameElement $nameElement
     * @param int $passengerQuantity
     * @param string $passengerTypeCode
     * @param string $ref
     * @param string $refClient
     */
    public function __construct(\App|C\StructType\NameElement $nameElement = null, $passengerQuantity = null, $passengerTypeCode = null, $ref = null, $refClient = null)
    {
        $this
            ->setNameElement($nameElement)
            ->setPassengerQuantity($passengerQuantity)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setRef($ref)
            ->setRefClient($refClient);
    }
    /**
     * Get NameElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\NameElement|null
     */
    public function getNameElement()
    {
        return isset($this->NameElement) ? $this->NameElement : null;
    }
    /**
     * Set NameElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\NameElement $nameElement
     * @return \App|C\StructType\Passenger
     */
    public function setNameElement(\App|C\StructType\NameElement $nameElement = null)
    {
        if (is_null($nameElement) || (is_array($nameElement) && empty($nameElement))) {
            unset($this->NameElement);
        } else {
            $this->NameElement = $nameElement;
        }
        return $this;
    }
    /**
     * Get PassengerQuantity value
     * @return int|null
     */
    public function getPassengerQuantity()
    {
        return $this->PassengerQuantity;
    }
    /**
     * Set PassengerQuantity value
     * @param int $passengerQuantity
     * @return \App|C\StructType\Passenger
     */
    public function setPassengerQuantity($passengerQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQuantity) && !(is_int($passengerQuantity) || ctype_digit($passengerQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerQuantity, true), gettype($passengerQuantity)), __LINE__);
        }
        $this->PassengerQuantity = $passengerQuantity;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return isset($this->PassengerTypeCode) ? $this->PassengerTypeCode : null;
    }
    /**
     * Set PassengerTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerTypeCode
     * @return \App|C\StructType\Passenger
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        if (is_null($passengerTypeCode) || (is_array($passengerTypeCode) && empty($passengerTypeCode))) {
            unset($this->PassengerTypeCode);
        } else {
            $this->PassengerTypeCode = $passengerTypeCode;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \App|C\StructType\Passenger
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
    /**
     * Get RefClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefClient()
    {
        return isset($this->RefClient) ? $this->RefClient : null;
    }
    /**
     * Set RefClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refClient
     * @return \App|C\StructType\Passenger
     */
    public function setRefClient($refClient = null)
    {
        // validation for constraint: string
        if (!is_null($refClient) && !is_string($refClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refClient, true), gettype($refClient)), __LINE__);
        }
        if (is_null($refClient) || (is_array($refClient) && empty($refClient))) {
            unset($this->RefClient);
        } else {
            $this->RefClient = $refClient;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\Passenger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
