<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinalStatusInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FinalStatusInfo
 * @subpackage Structs
 */
class FinalStatusInfo extends ApiObject
{
    /**
     * The LocalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocalDateTime;
    /**
     * The RefVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefVendor;
    /**
     * The UniversalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UniversalDateTime;
    /**
     * Constructor method for FinalStatusInfo
     * @uses FinalStatusInfo::setLocalDateTime()
     * @uses FinalStatusInfo::setRefVendor()
     * @uses FinalStatusInfo::setUniversalDateTime()
     * @param string $localDateTime
     * @param string $refVendor
     * @param string $universalDateTime
     */
    public function __construct($localDateTime = null, $refVendor = null, $universalDateTime = null)
    {
        $this
            ->setLocalDateTime($localDateTime)
            ->setRefVendor($refVendor)
            ->setUniversalDateTime($universalDateTime);
    }
    /**
     * Get LocalDateTime value
     * @return string|null
     */
    public function getLocalDateTime()
    {
        return $this->LocalDateTime;
    }
    /**
     * Set LocalDateTime value
     * @param string $localDateTime
     * @return \App|C\StructType\FinalStatusInfo
     */
    public function setLocalDateTime($localDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($localDateTime) && !is_string($localDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDateTime, true), gettype($localDateTime)), __LINE__);
        }
        $this->LocalDateTime = $localDateTime;
        return $this;
    }
    /**
     * Get RefVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefVendor()
    {
        return isset($this->RefVendor) ? $this->RefVendor : null;
    }
    /**
     * Set RefVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refVendor
     * @return \App|C\StructType\FinalStatusInfo
     */
    public function setRefVendor($refVendor = null)
    {
        // validation for constraint: string
        if (!is_null($refVendor) && !is_string($refVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refVendor, true), gettype($refVendor)), __LINE__);
        }
        if (is_null($refVendor) || (is_array($refVendor) && empty($refVendor))) {
            unset($this->RefVendor);
        } else {
            $this->RefVendor = $refVendor;
        }
        return $this;
    }
    /**
     * Get UniversalDateTime value
     * @return string|null
     */
    public function getUniversalDateTime()
    {
        return $this->UniversalDateTime;
    }
    /**
     * Set UniversalDateTime value
     * @param string $universalDateTime
     * @return \App|C\StructType\FinalStatusInfo
     */
    public function setUniversalDateTime($universalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($universalDateTime) && !is_string($universalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($universalDateTime, true), gettype($universalDateTime)), __LINE__);
        }
        $this->UniversalDateTime = $universalDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\FinalStatusInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
