<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Document
 * @subpackage Structs
 */
class Document extends SpecialServiceDataFoid
{
    /**
     * The DateOfBirth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfBirth;
    /**
     * The DocumentExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentExpiryDate;
    /**
     * The DocumentIssuanceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentIssuanceDate;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Firstname;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The IssueCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueCountryCode;
    /**
     * The NationalityCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NationalityCountryCode;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Surname;
    /**
     * Constructor method for Document
     * @uses Document::setDateOfBirth()
     * @uses Document::setDocumentExpiryDate()
     * @uses Document::setDocumentIssuanceDate()
     * @uses Document::setFirstname()
     * @uses Document::setGender()
     * @uses Document::setIssueCountryCode()
     * @uses Document::setNationalityCountryCode()
     * @uses Document::setSurname()
     * @param string $dateOfBirth
     * @param string $documentExpiryDate
     * @param string $documentIssuanceDate
     * @param string $firstname
     * @param string $gender
     * @param string $issueCountryCode
     * @param string $nationalityCountryCode
     * @param string $surname
     */
    public function __construct($dateOfBirth = null, $documentExpiryDate = null, $documentIssuanceDate = null, $firstname = null, $gender = null, $issueCountryCode = null, $nationalityCountryCode = null, $surname = null)
    {
        $this
            ->setDateOfBirth($dateOfBirth)
            ->setDocumentExpiryDate($documentExpiryDate)
            ->setDocumentIssuanceDate($documentIssuanceDate)
            ->setFirstname($firstname)
            ->setGender($gender)
            ->setIssueCountryCode($issueCountryCode)
            ->setNationalityCountryCode($nationalityCountryCode)
            ->setSurname($surname);
    }
    /**
     * Get DateOfBirth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return isset($this->DateOfBirth) ? $this->DateOfBirth : null;
    }
    /**
     * Set DateOfBirth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfBirth
     * @return \App|C\StructType\Document
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        if (is_null($dateOfBirth) || (is_array($dateOfBirth) && empty($dateOfBirth))) {
            unset($this->DateOfBirth);
        } else {
            $this->DateOfBirth = $dateOfBirth;
        }
        return $this;
    }
    /**
     * Get DocumentExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentExpiryDate()
    {
        return isset($this->DocumentExpiryDate) ? $this->DocumentExpiryDate : null;
    }
    /**
     * Set DocumentExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentExpiryDate
     * @return \App|C\StructType\Document
     */
    public function setDocumentExpiryDate($documentExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentExpiryDate) && !is_string($documentExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentExpiryDate, true), gettype($documentExpiryDate)), __LINE__);
        }
        if (is_null($documentExpiryDate) || (is_array($documentExpiryDate) && empty($documentExpiryDate))) {
            unset($this->DocumentExpiryDate);
        } else {
            $this->DocumentExpiryDate = $documentExpiryDate;
        }
        return $this;
    }
    /**
     * Get DocumentIssuanceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentIssuanceDate()
    {
        return isset($this->DocumentIssuanceDate) ? $this->DocumentIssuanceDate : null;
    }
    /**
     * Set DocumentIssuanceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentIssuanceDate
     * @return \App|C\StructType\Document
     */
    public function setDocumentIssuanceDate($documentIssuanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentIssuanceDate) && !is_string($documentIssuanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentIssuanceDate, true), gettype($documentIssuanceDate)), __LINE__);
        }
        if (is_null($documentIssuanceDate) || (is_array($documentIssuanceDate) && empty($documentIssuanceDate))) {
            unset($this->DocumentIssuanceDate);
        } else {
            $this->DocumentIssuanceDate = $documentIssuanceDate;
        }
        return $this;
    }
    /**
     * Get Firstname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstname()
    {
        return isset($this->Firstname) ? $this->Firstname : null;
    }
    /**
     * Set Firstname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstname
     * @return \App|C\StructType\Document
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        if (is_null($firstname) || (is_array($firstname) && empty($firstname))) {
            unset($this->Firstname);
        } else {
            $this->Firstname = $firstname;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gender
     * @return \App|C\StructType\Document
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get IssueCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueCountryCode()
    {
        return isset($this->IssueCountryCode) ? $this->IssueCountryCode : null;
    }
    /**
     * Set IssueCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueCountryCode
     * @return \App|C\StructType\Document
     */
    public function setIssueCountryCode($issueCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($issueCountryCode) && !is_string($issueCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueCountryCode, true), gettype($issueCountryCode)), __LINE__);
        }
        if (is_null($issueCountryCode) || (is_array($issueCountryCode) && empty($issueCountryCode))) {
            unset($this->IssueCountryCode);
        } else {
            $this->IssueCountryCode = $issueCountryCode;
        }
        return $this;
    }
    /**
     * Get NationalityCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalityCountryCode()
    {
        return isset($this->NationalityCountryCode) ? $this->NationalityCountryCode : null;
    }
    /**
     * Set NationalityCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalityCountryCode
     * @return \App|C\StructType\Document
     */
    public function setNationalityCountryCode($nationalityCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($nationalityCountryCode) && !is_string($nationalityCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalityCountryCode, true), gettype($nationalityCountryCode)), __LINE__);
        }
        if (is_null($nationalityCountryCode) || (is_array($nationalityCountryCode) && empty($nationalityCountryCode))) {
            unset($this->NationalityCountryCode);
        } else {
            $this->NationalityCountryCode = $nationalityCountryCode;
        }
        return $this;
    }
    /**
     * Get Surname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSurname()
    {
        return isset($this->Surname) ? $this->Surname : null;
    }
    /**
     * Set Surname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $surname
     * @return \App|C\StructType\Document
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        if (is_null($surname) || (is_array($surname) && empty($surname))) {
            unset($this->Surname);
        } else {
            $this->Surname = $surname;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
