<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoadBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadBooking $parameters
     * @return \App|C\StructType\LoadBookingResponse|bool
     */
    public function LoadBooking(\App|C\StructType\LoadBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadCustomer $parameters
     * @return \App|C\StructType\LoadCustomerResponse|bool
     */
    public function LoadCustomer(\App|C\StructType\LoadCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadFrequentFlyerAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\LoadFrequentFlyerAccount $parameters
     * @return \App|C\StructType\LoadFrequentFlyerAccountResponse|bool
     */
    public function LoadFrequentFlyerAccount(\App|C\StructType\LoadFrequentFlyerAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadFrequentFlyerAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\LoadBookingResponse|\App|C\StructType\LoadCustomerResponse|\App|C\StructType\LoadFrequentFlyerAccountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
