<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Frequent ServiceType
 * @subpackage Services
 */
class Frequent extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FrequentFlyerMileageCalculator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\FrequentFlyerMileageCalculator $parameters
     * @return \App|C\StructType\FrequentFlyerMileageCalculatorResponse|bool
     */
    public function FrequentFlyerMileageCalculator(\App|C\StructType\FrequentFlyerMileageCalculator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FrequentFlyerMileageCalculator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\FrequentFlyerMileageCalculatorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
