<?php

namespace App|C\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Eligible ServiceType
 * @subpackage Services
 */
class Eligible extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EligibleOriginDestinations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App|C\StructType\EligibleOriginDestinations $parameters
     * @return \App|C\StructType\EligibleOriginDestinationsResponse|bool
     */
    public function EligibleOriginDestinations(\App|C\StructType\EligibleOriginDestinations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EligibleOriginDestinations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App|C\StructType\EligibleOriginDestinationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
