<?php

namespace App|C\EnumType;

/**
 * This class stands for DistributionChannel EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DistributionChannel
 * @subpackage Enumerations
 */
class DistributionChannel
{
    /**
     * Constant for value 'FrontOffice'
     * @return string 'FrontOffice'
     */
    const VALUE_FRONT_OFFICE = 'FrontOffice';
    /**
     * Constant for value 'BackOffice'
     * @return string 'BackOffice'
     */
    const VALUE_BACK_OFFICE = 'BackOffice';
    /**
     * Constant for value 'Gds'
     * @return string 'Gds'
     */
    const VALUE_GDS = 'Gds';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FRONT_OFFICE
     * @uses self::VALUE_BACK_OFFICE
     * @uses self::VALUE_GDS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FRONT_OFFICE,
            self::VALUE_BACK_OFFICE,
            self::VALUE_GDS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
