<?php

namespace App|C\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPassenger ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPassenger
 * @subpackage Arrays
 */
class ArrayOfPassenger extends AbstractStructArrayBase
{
    /**
     * The Passenger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\Passenger[]
     */
    public $Passenger;
    /**
     * Constructor method for ArrayOfPassenger
     * @uses ArrayOfPassenger::setPassenger()
     * @param \App|C\StructType\Passenger[] $passenger
     */
    public function __construct(array $passenger = array())
    {
        $this
            ->setPassenger($passenger);
    }
    /**
     * Get Passenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\Passenger[]|null
     */
    public function getPassenger()
    {
        return isset($this->Passenger) ? $this->Passenger : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPassenger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassenger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerForArrayConstraintsFromSetPassenger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPassengerPassengerItem) {
            // validation for constraint: itemType
            if (!$arrayOfPassengerPassengerItem instanceof \App|C\StructType\Passenger) {
                $invalidValues[] = is_object($arrayOfPassengerPassengerItem) ? get_class($arrayOfPassengerPassengerItem) : sprintf('%s(%s)', gettype($arrayOfPassengerPassengerItem), var_export($arrayOfPassengerPassengerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Passenger property can only contain items of type \App|C\StructType\Passenger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Passenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\Passenger[] $passenger
     * @return \App|C\ArrayType\ArrayOfPassenger
     */
    public function setPassenger(array $passenger = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerArrayErrorMessage = self::validatePassengerForArrayConstraintsFromSetPassenger($passenger))) {
            throw new \InvalidArgumentException($passengerArrayErrorMessage, __LINE__);
        }
        if (is_null($passenger) || (is_array($passenger) && empty($passenger))) {
            unset($this->Passenger);
        } else {
            $this->Passenger = $passenger;
        }
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \App|C\StructType\Passenger $item
     * @return \App|C\ArrayType\ArrayOfPassenger
     */
    public function addToPassenger(\App|C\StructType\Passenger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App|C\StructType\Passenger) {
            throw new \InvalidArgumentException(sprintf('The Passenger property can only contain items of type \App|C\StructType\Passenger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App|C\StructType\Passenger|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App|C\StructType\Passenger|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App|C\StructType\Passenger|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App|C\StructType\Passenger|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App|C\StructType\Passenger|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Passenger
     */
    public function getAttributeName()
    {
        return 'Passenger';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\ArrayType\ArrayOfPassenger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
