<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketAmountDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketAmountDetails
 * @subpackage Structs
 */
class TicketAmountDetails extends AmountDetails
{
    /**
     * The BaseCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseCurrencyCode;
    /**
     * The CurrencyRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\CurrencyRates
     */
    public $CurrencyRates;
    /**
     * The FareCalculation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareCalculation;
    /**
     * The FareCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareCurrencyCode;
    /**
     * Constructor method for TicketAmountDetails
     * @uses TicketAmountDetails::setBaseCurrencyCode()
     * @uses TicketAmountDetails::setCurrencyRates()
     * @uses TicketAmountDetails::setFareCalculation()
     * @uses TicketAmountDetails::setFareCurrencyCode()
     * @param string $baseCurrencyCode
     * @param \App|C\StructType\CurrencyRates $currencyRates
     * @param string $fareCalculation
     * @param string $fareCurrencyCode
     */
    public function __construct($baseCurrencyCode = null, \App|C\StructType\CurrencyRates $currencyRates = null, $fareCalculation = null, $fareCurrencyCode = null)
    {
        $this
            ->setBaseCurrencyCode($baseCurrencyCode)
            ->setCurrencyRates($currencyRates)
            ->setFareCalculation($fareCalculation)
            ->setFareCurrencyCode($fareCurrencyCode);
    }
    /**
     * Get BaseCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseCurrencyCode()
    {
        return isset($this->BaseCurrencyCode) ? $this->BaseCurrencyCode : null;
    }
    /**
     * Set BaseCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseCurrencyCode
     * @return \App|C\StructType\TicketAmountDetails
     */
    public function setBaseCurrencyCode($baseCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrencyCode) && !is_string($baseCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurrencyCode, true), gettype($baseCurrencyCode)), __LINE__);
        }
        if (is_null($baseCurrencyCode) || (is_array($baseCurrencyCode) && empty($baseCurrencyCode))) {
            unset($this->BaseCurrencyCode);
        } else {
            $this->BaseCurrencyCode = $baseCurrencyCode;
        }
        return $this;
    }
    /**
     * Get CurrencyRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\CurrencyRates|null
     */
    public function getCurrencyRates()
    {
        return isset($this->CurrencyRates) ? $this->CurrencyRates : null;
    }
    /**
     * Set CurrencyRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\CurrencyRates $currencyRates
     * @return \App|C\StructType\TicketAmountDetails
     */
    public function setCurrencyRates(\App|C\StructType\CurrencyRates $currencyRates = null)
    {
        if (is_null($currencyRates) || (is_array($currencyRates) && empty($currencyRates))) {
            unset($this->CurrencyRates);
        } else {
            $this->CurrencyRates = $currencyRates;
        }
        return $this;
    }
    /**
     * Get FareCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareCalculation()
    {
        return isset($this->FareCalculation) ? $this->FareCalculation : null;
    }
    /**
     * Set FareCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareCalculation
     * @return \App|C\StructType\TicketAmountDetails
     */
    public function setFareCalculation($fareCalculation = null)
    {
        // validation for constraint: string
        if (!is_null($fareCalculation) && !is_string($fareCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCalculation, true), gettype($fareCalculation)), __LINE__);
        }
        if (is_null($fareCalculation) || (is_array($fareCalculation) && empty($fareCalculation))) {
            unset($this->FareCalculation);
        } else {
            $this->FareCalculation = $fareCalculation;
        }
        return $this;
    }
    /**
     * Get FareCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareCurrencyCode()
    {
        return isset($this->FareCurrencyCode) ? $this->FareCurrencyCode : null;
    }
    /**
     * Set FareCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareCurrencyCode
     * @return \App|C\StructType\TicketAmountDetails
     */
    public function setFareCurrencyCode($fareCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareCurrencyCode) && !is_string($fareCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCurrencyCode, true), gettype($fareCurrencyCode)), __LINE__);
        }
        if (is_null($fareCurrencyCode) || (is_array($fareCurrencyCode) && empty($fareCurrencyCode))) {
            unset($this->FareCurrencyCode);
        } else {
            $this->FareCurrencyCode = $fareCurrencyCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\TicketAmountDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
