<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Penalty StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Penalty
 * @subpackage Structs
 */
class Penalty extends ApiObject
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App|C\StructType\AmountBase
     */
    public $Amount;
    /**
     * The FromHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromHours;
    /**
     * The IsNoShowPenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNoShowPenalty;
    /**
     * The ToHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToHours;
    /**
     * Constructor method for Penalty
     * @uses Penalty::setAmount()
     * @uses Penalty::setFromHours()
     * @uses Penalty::setIsNoShowPenalty()
     * @uses Penalty::setToHours()
     * @param \App|C\StructType\AmountBase $amount
     * @param int $fromHours
     * @param bool $isNoShowPenalty
     * @param int $toHours
     */
    public function __construct(\App|C\StructType\AmountBase $amount = null, $fromHours = null, $isNoShowPenalty = null, $toHours = null)
    {
        $this
            ->setAmount($amount)
            ->setFromHours($fromHours)
            ->setIsNoShowPenalty($isNoShowPenalty)
            ->setToHours($toHours);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App|C\StructType\AmountBase|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App|C\StructType\AmountBase $amount
     * @return \App|C\StructType\Penalty
     */
    public function setAmount(\App|C\StructType\AmountBase $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get FromHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromHours()
    {
        return isset($this->FromHours) ? $this->FromHours : null;
    }
    /**
     * Set FromHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromHours
     * @return \App|C\StructType\Penalty
     */
    public function setFromHours($fromHours = null)
    {
        // validation for constraint: int
        if (!is_null($fromHours) && !(is_int($fromHours) || ctype_digit($fromHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromHours, true), gettype($fromHours)), __LINE__);
        }
        if (is_null($fromHours) || (is_array($fromHours) && empty($fromHours))) {
            unset($this->FromHours);
        } else {
            $this->FromHours = $fromHours;
        }
        return $this;
    }
    /**
     * Get IsNoShowPenalty value
     * @return bool|null
     */
    public function getIsNoShowPenalty()
    {
        return $this->IsNoShowPenalty;
    }
    /**
     * Set IsNoShowPenalty value
     * @param bool $isNoShowPenalty
     * @return \App|C\StructType\Penalty
     */
    public function setIsNoShowPenalty($isNoShowPenalty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNoShowPenalty) && !is_bool($isNoShowPenalty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNoShowPenalty, true), gettype($isNoShowPenalty)), __LINE__);
        }
        $this->IsNoShowPenalty = $isNoShowPenalty;
        return $this;
    }
    /**
     * Get ToHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToHours()
    {
        return isset($this->ToHours) ? $this->ToHours : null;
    }
    /**
     * Set ToHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toHours
     * @return \App|C\StructType\Penalty
     */
    public function setToHours($toHours = null)
    {
        // validation for constraint: int
        if (!is_null($toHours) && !(is_int($toHours) || ctype_digit($toHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toHours, true), gettype($toHours)), __LINE__);
        }
        if (is_null($toHours) || (is_array($toHours) && empty($toHours))) {
            unset($this->ToHours);
        } else {
            $this->ToHours = $toHours;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\Penalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
