<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinePaymentInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OnlinePaymentInfo
 * @subpackage Structs
 */
class OnlinePaymentInfo extends ApiObject
{
    /**
     * The AllowIFrame
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowIFrame;
    /**
     * The LogoUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoUrl;
    /**
     * The Use3DSecure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Use3DSecure;
    /**
     * The UseRedirection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseRedirection;
    /**
     * The VATRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VATRate;
    /**
     * Constructor method for OnlinePaymentInfo
     * @uses OnlinePaymentInfo::setAllowIFrame()
     * @uses OnlinePaymentInfo::setLogoUrl()
     * @uses OnlinePaymentInfo::setUse3DSecure()
     * @uses OnlinePaymentInfo::setUseRedirection()
     * @uses OnlinePaymentInfo::setVATRate()
     * @param bool $allowIFrame
     * @param string $logoUrl
     * @param bool $use3DSecure
     * @param bool $useRedirection
     * @param float $vATRate
     */
    public function __construct($allowIFrame = null, $logoUrl = null, $use3DSecure = null, $useRedirection = null, $vATRate = null)
    {
        $this
            ->setAllowIFrame($allowIFrame)
            ->setLogoUrl($logoUrl)
            ->setUse3DSecure($use3DSecure)
            ->setUseRedirection($useRedirection)
            ->setVATRate($vATRate);
    }
    /**
     * Get AllowIFrame value
     * @return bool|null
     */
    public function getAllowIFrame()
    {
        return $this->AllowIFrame;
    }
    /**
     * Set AllowIFrame value
     * @param bool $allowIFrame
     * @return \App|C\StructType\OnlinePaymentInfo
     */
    public function setAllowIFrame($allowIFrame = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowIFrame) && !is_bool($allowIFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowIFrame, true), gettype($allowIFrame)), __LINE__);
        }
        $this->AllowIFrame = $allowIFrame;
        return $this;
    }
    /**
     * Get LogoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoUrl()
    {
        return isset($this->LogoUrl) ? $this->LogoUrl : null;
    }
    /**
     * Set LogoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoUrl
     * @return \App|C\StructType\OnlinePaymentInfo
     */
    public function setLogoUrl($logoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoUrl) && !is_string($logoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoUrl, true), gettype($logoUrl)), __LINE__);
        }
        if (is_null($logoUrl) || (is_array($logoUrl) && empty($logoUrl))) {
            unset($this->LogoUrl);
        } else {
            $this->LogoUrl = $logoUrl;
        }
        return $this;
    }
    /**
     * Get Use3DSecure value
     * @return bool|null
     */
    public function getUse3DSecure()
    {
        return $this->Use3DSecure;
    }
    /**
     * Set Use3DSecure value
     * @param bool $use3DSecure
     * @return \App|C\StructType\OnlinePaymentInfo
     */
    public function setUse3DSecure($use3DSecure = null)
    {
        // validation for constraint: boolean
        if (!is_null($use3DSecure) && !is_bool($use3DSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use3DSecure, true), gettype($use3DSecure)), __LINE__);
        }
        $this->Use3DSecure = $use3DSecure;
        return $this;
    }
    /**
     * Get UseRedirection value
     * @return bool|null
     */
    public function getUseRedirection()
    {
        return $this->UseRedirection;
    }
    /**
     * Set UseRedirection value
     * @param bool $useRedirection
     * @return \App|C\StructType\OnlinePaymentInfo
     */
    public function setUseRedirection($useRedirection = null)
    {
        // validation for constraint: boolean
        if (!is_null($useRedirection) && !is_bool($useRedirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useRedirection, true), gettype($useRedirection)), __LINE__);
        }
        $this->UseRedirection = $useRedirection;
        return $this;
    }
    /**
     * Get VATRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVATRate()
    {
        return isset($this->VATRate) ? $this->VATRate : null;
    }
    /**
     * Set VATRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vATRate
     * @return \App|C\StructType\OnlinePaymentInfo
     */
    public function setVATRate($vATRate = null)
    {
        // validation for constraint: float
        if (!is_null($vATRate) && !(is_float($vATRate) || is_numeric($vATRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vATRate, true), gettype($vATRate)), __LINE__);
        }
        if (is_null($vATRate) || (is_array($vATRate) && empty($vATRate))) {
            unset($this->VATRate);
        } else {
            $this->VATRate = $vATRate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\OnlinePaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
