<?php

namespace App|C\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagAllowance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BagAllowance
 * @subpackage Structs
 */
class BagAllowance extends ApiObject
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Weight;
    /**
     * The WeightMeasureQualifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WeightMeasureQualifier;
    /**
     * Constructor method for BagAllowance
     * @uses BagAllowance::setQuantity()
     * @uses BagAllowance::setWeight()
     * @uses BagAllowance::setWeightMeasureQualifier()
     * @param int $quantity
     * @param float $weight
     * @param string $weightMeasureQualifier
     */
    public function __construct($quantity = null, $weight = null, $weightMeasureQualifier = null)
    {
        $this
            ->setQuantity($quantity)
            ->setWeight($weight)
            ->setWeightMeasureQualifier($weightMeasureQualifier);
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \App|C\StructType\BagAllowance
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \App|C\StructType\BagAllowance
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get WeightMeasureQualifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeightMeasureQualifier()
    {
        return isset($this->WeightMeasureQualifier) ? $this->WeightMeasureQualifier : null;
    }
    /**
     * Set WeightMeasureQualifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weightMeasureQualifier
     * @return \App|C\StructType\BagAllowance
     */
    public function setWeightMeasureQualifier($weightMeasureQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($weightMeasureQualifier) && !is_string($weightMeasureQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightMeasureQualifier, true), gettype($weightMeasureQualifier)), __LINE__);
        }
        if (is_null($weightMeasureQualifier) || (is_array($weightMeasureQualifier) && empty($weightMeasureQualifier))) {
            unset($this->WeightMeasureQualifier);
        } else {
            $this->WeightMeasureQualifier = $weightMeasureQualifier;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App|C\StructType\BagAllowance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
